/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.selectiveAttention.app;

import hsr.pma.testapp.selectiveAttention.app.Application;
import hsr.pma.testapp.selectiveAttention.pd.FeedbackStep;
import hsr.pma.testapp.selectiveAttention.pd.RuleStep;
import hsr.pma.testapp.selectiveAttention.pd.Step;
import hsr.pma.testapp.selectiveAttention.pd.TestStep;
import hsr.pma.testapp.selectiveAttention.pd.TestsequenceStep;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomizedStepGenerator
implements Serializable {
    private static final int TRIPLET = 3;
    private static final long serialVersionUID = 1L;
    private Random random = new Random(System.currentTimeMillis());
    private Application app;

    public RandomizedStepGenerator(Application app) {
        this.app = app;
    }

    public List<Step> buildExercisesequence(String alphabet, int duration, int feedbackduration, int critical, int frequency, int testsetpquantity, String ruleStepText, int ruleGap, boolean instruction) {
        List<Step> steps = this.buildTestsequence(alphabet, duration, critical, frequency, testsetpquantity, ruleStepText, ruleGap);
        if (instruction) {
            int i = 0;
            while (i < steps.size()) {
                if (steps.get(i) instanceof TestStep) {
                    steps.add(i + 1, new FeedbackStep((TestStep)steps.get(i), feedbackduration));
                }
                ++i;
            }
        }
        return steps;
    }

    public List<Step> buildTestsequence(String alphabet, int duration, int critical, int frequency, int testsetpquantity, String ruleStepText, int ruleGap) {
        ArrayList<Step> steps = new ArrayList<Step>();
        String[] criticalsequences = this.buildCritical(alphabet, critical);
        String[] teststepsequences = this.buildTestStepSequences(alphabet, criticalsequences, frequency, testsetpquantity);
        steps.add(new RuleStep(ruleStepText, criticalsequences, ruleGap));
        TestStep[] tests = new TestStep[teststepsequences.length];
        int i = 0;
        while (i < teststepsequences.length) {
            tests[i] = new TestStep(teststepsequences[i], duration, this.doesContain(teststepsequences[i], criticalsequences));
            steps.add(tests[i]);
            ++i;
        }
        steps.add(new TestsequenceStep(tests, this.app));
        return steps;
    }

    private boolean doesContain(String subject, String[] collection) {
        String[] stringArray = collection;
        int n = collection.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null && s.equals(subject)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String[] buildTestStepSequences(String alphabet, String[] criticalsequences, int frequency, int testsetpquantity) {
        String[] teststepsequences = new String[testsetpquantity];
        int i = 0;
        while (i < teststepsequences.length) {
            String next;
            while (this.doesContain(next = this.buildTriplet(alphabet), teststepsequences) || this.doesContain(next, criticalsequences)) {
            }
            teststepsequences[i] = next;
            ++i;
        }
        int[] criticalplacement = this.buildRandom(frequency, testsetpquantity);
        int i2 = 0;
        while (i2 < criticalplacement.length) {
            String choosenCriticalSequence;
            teststepsequences[criticalplacement[i2]] = choosenCriticalSequence = criticalsequences[criticalsequences.length - 1 > 0 ? this.random.nextInt(criticalsequences.length) : 0];
            ++i2;
        }
        return teststepsequences;
    }

    private int[] buildRandom(int amount, int max) {
        int[] res = new int[amount];
        int i = 0;
        while (i < amount) {
            res[i] = -1;
            ++i;
        }
        i = 0;
        while (i < res.length) {
            int next;
            boolean isdublicate;
            do {
                isdublicate = false;
                next = this.random.nextInt(max);
                int[] nArray = res;
                int n = res.length;
                int n2 = 0;
                while (n2 < n) {
                    int j = nArray[n2];
                    if (j == next) {
                        isdublicate = true;
                    }
                    ++n2;
                }
            } while (isdublicate);
            res[i] = next;
            ++i;
        }
        return res;
    }

    private String[] buildCritical(String alphabet, int count) {
        String[] criticalsequences = new String[count];
        int i = 0;
        while (i < criticalsequences.length) {
            String next;
            while (this.doesContain(next = this.buildTriplet(alphabet), criticalsequences)) {
            }
            criticalsequences[i] = next;
            ++i;
        }
        return criticalsequences;
    }

    private String buildTriplet(String alphabet) {
        int[] placement;
        StringBuilder res = new StringBuilder();
        int[] nArray = placement = this.buildRandom(3, alphabet.length() - 1);
        int n = placement.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            res.append(alphabet.charAt(index));
            ++n2;
        }
        return res.toString();
    }
}

