/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.selectiveAttention.sound;

import hsr.pma.testapp.selectiveAttention.sound.SoundLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;

public class Synthesizer
implements Serializable {
    public static boolean DEBUG = false;
    private static final long serialVersionUID = 1L;
    private static final int BUFFER_SIZE = 4096;
    private transient Hashtable<String, byte[]> sounds;
    private AtomicBoolean stopRequested = new AtomicBoolean();
    private SourceDataLine audioLine = null;
    private float volume = 0.0f;

    public void prepare() {
        this.sounds = new SoundLoader().load();
    }

    public void play(String sequence) {
        if (DEBUG) {
            System.out.println("[Synthesizer] play sequence " + sequence);
        }
        if (this.audioLine != null) {
            System.out.println("[Synthesizer] Audioline still busy, wait until ready");
            this.stopRequested.set(true);
            while (this.audioLine != null) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
        }
        this.stopRequested.set(false);
        char[] cArray = sequence.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (this.stopRequested.get()) {
                return;
            }
            this.playCharacter(c);
            ++n2;
        }
    }

    protected void setVolume(float volume) {
        this.volume = volume;
    }

    protected float getVolume() {
        return this.volume;
    }

    private void playCharacter(char c) {
        if (DEBUG) {
            System.out.println("[Synthesizer] play character " + c);
        }
        AudioInputStream audioStream = null;
        try {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(this.sounds.get("" + c));
                audioStream = AudioSystem.getAudioInputStream(in);
                AudioFormat format = audioStream.getFormat();
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
                this.audioLine = (SourceDataLine)AudioSystem.getLine(info);
                this.audioLine.open(format);
                FloatControl gainControl = (FloatControl)this.audioLine.getControl(FloatControl.Type.MASTER_GAIN);
                gainControl.setValue(this.volume);
                this.audioLine.start();
                byte[] bytesBuffer = new byte[4096];
                int bytesRead = -1;
                while ((bytesRead = audioStream.read(bytesBuffer)) != -1) {
                    this.audioLine.write(bytesBuffer, 0, bytesRead);
                }
                this.audioLine.drain();
                this.audioLine.close();
                this.audioLine = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    audioStream.close();
                    this.audioLine = null;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                audioStream.close();
                this.audioLine = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        if (this.audioLine == null) {
            return;
        }
        this.stopRequested.set(true);
    }

    public static void main(String[] args) {
        Synthesizer s = new Synthesizer();
        s.prepare();
        s.play("AQS");
    }
}

