/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.selectiveAttention.ui;

import hsr.pma.app.view.graphics.ApplicationLayouter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SelectiveAttentionLayouter
extends ApplicationLayouter {
    public static final int FONT_SIZE_TITLE_VOLUME = 105;

    public SelectiveAttentionLayouter(JPanel panel) {
        super(panel);
    }

    public void layoutVolumeButtonLabels(JButton decVolume, JButton incVolume, JLabel labelDec, JLabel labelInc) {
        decVolume.setFont(this.gc.getFontBold(100));
        incVolume.setFont(this.gc.getFontBold(100));
        labelDec.setFont(this.gc.getFont(100));
        labelDec.setForeground(COLOR_TITLE);
        labelInc.setFont(this.gc.getFont(100));
        labelInc.setForeground(COLOR_TITLE);
        int buttonSize = this.gc.getButtonSize();
        Insets b = this.gc.getBorder();
        int yOffset = this.gc.getSize().height - b.bottom - (int)(2.5 * (double)buttonSize);
        decVolume.setBounds(b.left, yOffset, buttonSize, buttonSize);
        incVolume.setBounds(this.gc.getSize().width - b.left - buttonSize, yOffset, buttonSize, buttonSize);
        Dimension labelSize = labelDec.getPreferredSize();
        int xOffsetLabel = (buttonSize - labelSize.width) / 2;
        int yOffsetLabel = yOffset - this.gc.getAnswerButtonLabelYGap() - labelSize.height;
        labelDec.setBounds(b.left + xOffsetLabel, yOffsetLabel, labelSize.width, labelSize.height);
        labelSize = labelInc.getPreferredSize();
        xOffsetLabel = (buttonSize - labelSize.width) / 2;
        labelInc.setBounds(this.gc.getSize().width - b.left - buttonSize + xOffsetLabel, yOffsetLabel, labelSize.width, labelSize.height);
    }

    public void layoutVolumeSlider(int actualVolume, Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int buttonSize = this.gc.getButtonSize();
        Insets b = this.gc.getBorder();
        int xGap = buttonSize / 4;
        int xSlider = b.left + buttonSize + xGap;
        int ySlider = this.gc.getSize().height - b.bottom - (int)(2.125 * (double)buttonSize);
        int width = this.gc.getSize().width - b.left - b.right - (int)(2.5 * (double)buttonSize);
        int height = xGap;
        g2.drawRect(xSlider, ySlider, width, height);
        float widthBar = (float)(actualVolume - 50) / 50.0f;
        int volumeBarWidth = (int)((float)width * widthBar);
        g2.fillRect(xSlider, ySlider, volumeBarWidth, height);
    }

    public void layoutAnswerButton(JButton but) {
        but.setFont(this.gc.getFontBold(100));
        int buttonSize = this.gc.getButtonSize();
        int xOffset = (this.gc.getSize().width - buttonSize) / 2;
        int yOffset = this.gc.getSize().height - this.gc.getBorder().bottom - buttonSize;
        but.setBounds(xOffset, yOffset, buttonSize, buttonSize);
    }

    public void layoutSpeaker(Graphics2D g2) {
        Insets b = this.gc.getBorder();
        int size = this.gc.getSize().height - b.top - b.bottom - 3 * this.gc.getButtonSize();
        int xOffset = (this.gc.getSize().width - size) / 2;
        int yOffset = b.top + this.gc.getButtonSize();
        float lineWidth = (float)((double)this.gc.getButtonSize() * 0.04);
        g2.setColor(Color.black);
        g2.setStroke(new BasicStroke(lineWidth));
        g2.drawOval(xOffset, yOffset, size, size);
        g2.drawOval(xOffset - size / 4, yOffset + size / 4, size / 4, size / 2);
        g2.drawOval(xOffset + size, yOffset + size / 4, size / 4, size / 2);
        g2.setStroke(new BasicStroke(lineWidth * 3.0f));
        g2.drawArc(xOffset - size / 8, yOffset - size / 8, 5 * size / 4, 5 * size / 4, 25, 130);
    }

    public void layoutFeedback(boolean ok, Graphics2D g2) {
        BufferedImage img = ok ? this.gc.getFeedbackOkImage() : this.gc.getFeedbackFailImage();
        int imgSize = this.gc.getFeedbackImageSize();
        int buttonSize = this.gc.getButtonSize();
        int gap = (buttonSize - imgSize) / 2;
        int xOffset = (this.gc.getSize().width - buttonSize) / 2 + buttonSize + gap;
        int yOffset = this.gc.getSize().height - this.gc.getBorder().bottom - buttonSize + gap;
        g2.drawImage((Image)img, xOffset, yOffset, null);
    }
}

