/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.app.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

public class TimeFormater
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static String formatMillisSystemTime(long millis) {
        if (millis == 0L) {
            return "00:00:00.000";
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        StringBuilder buf = new StringBuilder();
        String hours = "" + cal.get(11);
        if (hours.length() == 1) {
            hours = "0" + hours;
        }
        buf.append(hours);
        buf.append(':');
        String min = "" + cal.get(12);
        if (min.length() == 1) {
            min = "0" + min;
        }
        buf.append(min);
        buf.append(':');
        String sec = "" + cal.get(13);
        if (sec.length() == 1) {
            sec = "0" + sec;
        }
        buf.append(sec);
        buf.append('.');
        String ms = "" + cal.get(14);
        if (ms.length() == 1) {
            ms = "00" + ms;
        } else if (ms.length() == 2) {
            ms = "0" + ms;
        }
        buf.append(ms);
        return buf.toString();
    }

    public static String formatSystemTime(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        StringBuilder buf = new StringBuilder();
        String hours = "" + cal.get(11);
        if (hours.length() == 1) {
            hours = "0" + hours;
        }
        buf.append(hours);
        buf.append(':');
        String min = "" + cal.get(12);
        if (min.length() == 1) {
            min = "0" + min;
        }
        buf.append(min);
        buf.append(':');
        String sec = "" + cal.get(13);
        if (sec.length() == 1) {
            sec = "0" + sec;
        }
        buf.append(sec);
        return buf.toString();
    }

    public static String formatMillis(long millis) {
        int hour = (int)(millis / 3600000L);
        int rest = (int)(millis % 3600000L);
        int min = rest / 60000;
        int sec = (rest %= 60000) / 1000;
        int ms = rest % 1000;
        StringBuilder buf = new StringBuilder();
        String hours = "" + hour;
        if (hours.length() == 1) {
            hours = "0" + hours;
        }
        buf.append(hours);
        buf.append(':');
        String mins = "" + min;
        if (mins.length() == 1) {
            mins = "0" + mins;
        }
        buf.append(mins);
        buf.append(':');
        String secs = "" + sec;
        if (secs.length() == 1) {
            secs = "0" + secs;
        }
        buf.append(secs);
        buf.append('.');
        String mss = "" + ms;
        if (mss.length() == 1) {
            mss = "00" + mss;
        }
        if (mss.length() == 2) {
            mss = "0" + mss;
        }
        buf.append(mss);
        return buf.toString();
    }

    public static long convertMillis(long systemTimeInMillis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(systemTimeInMillis);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        int ms = cal.get(14);
        long time = hour * 3600000 + min * 60000 + sec * 1000 + ms;
        return time;
    }

    public static long parseTimeString(String timestamp) {
        if (timestamp.equals("00:00:00.000")) {
            return 0L;
        }
        StringTokenizer st = new StringTokenizer(timestamp, ":");
        String hours = st.nextToken();
        int hour = Integer.parseInt(hours);
        String mins = st.nextToken();
        int min = Integer.parseInt(mins);
        String rest = st.nextToken();
        StringTokenizer st2 = new StringTokenizer(rest, ".");
        String secs = st2.nextToken();
        int sec = Integer.parseInt(secs);
        String mss = st2.nextToken();
        int ms = Integer.parseInt(mss);
        long time = hour * 3600000 + min * 60000 + sec * 1000 + ms;
        return time;
    }

    public static long getTimeFromTimeMillis(String time, String millis) {
        StringTokenizer st = new StringTokenizer(time, ":");
        int hour = Integer.parseInt(st.nextToken());
        int minute = Integer.parseInt(st.nextToken());
        int second = Integer.parseInt(st.nextToken());
        int _millis = Integer.parseInt(millis);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, _millis);
        return cal.getTimeInMillis();
    }

    public static void main(String[] args) {
        long time = TimeFormater.parseTimeString("14:05:12.012");
        System.out.println("Time = " + TimeFormater.formatMillis(time));
        long time2 = TimeFormater.parseTimeString("23:55:00.001");
        System.out.println("Time = " + TimeFormater.formatMillis(time2));
        long time3 = TimeFormater.parseTimeString("00:00:00.005");
        System.out.println("Time = " + TimeFormater.formatMillis(time3));
        long time3a = TimeFormater.parseTimeString("23:59:59.999");
        System.out.println("Millis = " + time3a);
        Date now = new Date();
        System.out.println("Now: " + now);
        long millis = TimeFormater.convertMillis(now.getTime());
        String time4 = TimeFormater.formatMillis(millis);
        System.out.println("Time= " + time4);
        long millis2 = TimeFormater.parseTimeString(time4);
        Date date = new Date(millis2);
        System.out.println("Date: " + date);
    }
}

