/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.memorization.controller;

import hsr.pma.app.DefaultTestApplication;
import hsr.pma.app.IResultStep;
import hsr.pma.memorization.controller.Controller;
import hsr.pma.memorization.data.MemorizationApplicationResultStep;
import hsr.pma.memorization.model.xml.Configuration;
import hsr.pma.memorization.view.MainPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.jdom.Element;

public class MemorizationApplication
extends DefaultTestApplication {
    private static final long serialVersionUID = 1L;
    public static final String APPLICATION_NAME = "Memorization";
    public static final String CLASS_NAME = "hsr.pma.memorization.controller.MemorizationApplication";
    public static final String CLASS_NAME_RESULTSTEP = "hsr.pma.memorization.data.MemorizationApplicationResultStep";
    private Controller controller = new Controller(this);

    public static MemorizationApplication fromXML(Element el) {
        MemorizationApplication app = new MemorizationApplication();
        app.setAttributesFromXML(el);
        try {
            app.setConfiguration(el.getChild("Configuration"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return app;
    }

    @Override
    public void abort() {
    }

    @Override
    public String getApplicationName() {
        return APPLICATION_NAME;
    }

    @Override
    public String getClassName() {
        return MemorizationApplication.class.getName();
    }

    @Override
    public String getClassNameResultStep() {
        return MemorizationApplicationResultStep.class.getName();
    }

    @Override
    public Element getConfiguration() {
        return this.controller.getConfiguration().toXml();
    }

    @Override
    public void handleButtonPressed(int arg0) {
        this.controller.fireJoystickButtonPressed(arg0);
    }

    @Override
    public void init() {
    }

    @Override
    public void setConfiguration(Element el) {
        this.controller.setConfiguration(new Configuration(el));
    }

    @Override
    public void setPanel(JPanel panel) {
        panel.setLayout(new BorderLayout());
        panel.add((Component)new MainPanel(this.controller), "Center");
        panel.validate();
        panel.repaint();
    }

    @Override
    public void setResultSteps(ArrayList<IResultStep> steps) {
        this.controller.setResultSteps(steps);
    }

    @Override
    public void startFailover() {
        this.controller.startFailover();
    }

    @Override
    public void startInstruction() {
        this.controller.startInstruction();
    }

    @Override
    public void startTest() {
        this.controller.startTest();
    }

    @Override
    public void startTest(int index) {
        this.controller.startTest(index);
    }

    @Override
    public int getTestCount() {
        return this.controller.getTestCount();
    }

    @Override
    public void stopInstruction() {
        this.controller.stopInstruction();
    }

    @Override
    public void stopTest() {
        this.controller.stopTest();
    }

    @Override
    public Element toXML() {
        Element el = new Element("TestApplication");
        super.writeAttributesToXML(el);
        el.addContent(this.controller.getConfiguration().toXml());
        return el;
    }
}

