/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.memorization.model.xml;

import hsr.pma.Language;
import hsr.pma.memorization.model.xml.SimpleText;
import hsr.pma.memorization.model.xml.Text;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.jdom.Element;

public class Init
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Text instructionCommandTitle;
    private Text commandTitle;
    private Text commandText;
    private Text questionTitle;
    private Text questionText;
    private double interferenceTime = 1.5;
    private double feedbackTime = 0.5;
    private double testDelay = 0.5;
    private boolean displayTimer = false;
    private boolean displayNextButton = true;
    private boolean randomOperation = false;
    private boolean randomizedPool = false;
    private int randomizedPoolExerciseCount = 10;
    Random random = new Random(System.currentTimeMillis());
    private final List<SimpleText> joystickLabels = new ArrayList<SimpleText>();

    public Init(Element el) {
        Element jl;
        Element ex;
        this.instructionCommandTitle = new Text(el.getChild("InstructionCommandTitle"));
        this.commandTitle = new Text(el.getChild("CommandTitle"));
        this.commandText = new Text(el.getChild("CommandText"));
        this.questionTitle = new Text(el.getChild("QuestionTitle"));
        this.questionText = new Text(el.getChild("QuestionText"));
        this.interferenceTime = Double.parseDouble(el.getChildText("InterferenceTime"));
        this.feedbackTime = Double.parseDouble(el.getChildText("FeedbackTime"));
        this.displayTimer = Boolean.parseBoolean(el.getChildText("DisplayTimer"));
        this.displayNextButton = Boolean.parseBoolean(el.getChildText("DisplayNextButton"));
        if (el.getChild("RandomOperation") != null) {
            this.randomOperation = Boolean.parseBoolean(el.getChildText("RandomOperation"));
        }
        this.testDelay = (ex = el.getChild("TestDelay")) != null ? Double.parseDouble(ex.getText()) : this.feedbackTime;
        if (el.getChild("RandomizedPool") != null) {
            Element erp = el.getChild("RandomizedPool");
            this.randomizedPool = Boolean.parseBoolean(erp.getText());
            this.randomizedPoolExerciseCount = Integer.parseInt(erp.getAttributeValue("exerciseCount"));
        }
        if ((jl = el.getChild("JoystickLabels")) != null) {
            this.joystickLabels.add(new SimpleText(jl.getChild("Button1")));
            this.joystickLabels.add(new SimpleText(jl.getChild("Button2")));
            this.joystickLabels.add(new SimpleText(jl.getChild("Button3")));
            this.joystickLabels.add(new SimpleText(jl.getChild("Button4")));
        }
    }

    public void setLanguage(Language language) {
        this.instructionCommandTitle.setLanguage(language);
        this.commandTitle.setLanguage(language);
        this.commandText.setLanguage(language);
        this.questionTitle.setLanguage(language);
        this.questionText.setLanguage(language);
    }

    public Text getInstructionCommandTitle() {
        return this.instructionCommandTitle;
    }

    public Text getCommandTitle() {
        return this.commandTitle;
    }

    public Text getCommandText() {
        return this.commandText;
    }

    public Text getQuestionTitle() {
        return this.questionTitle;
    }

    public Text getQuestionText() {
        return this.questionText;
    }

    public double getInterferenceTime() {
        return this.interferenceTime;
    }

    public double getFeedbackTime() {
        return this.feedbackTime;
    }

    public double getTestDelay() {
        return this.testDelay;
    }

    public boolean isDisplayTimer() {
        return this.displayTimer;
    }

    public boolean isDisplayNextButton() {
        return this.displayNextButton;
    }

    public boolean isRandomOperation() {
        return this.randomOperation;
    }

    public List<SimpleText> getJoystickLabels() {
        return this.joystickLabels;
    }

    public boolean isRandomizedPool() {
        return this.randomizedPool;
    }

    public int getRandomizedPoolExerciseCount() {
        return this.randomizedPoolExerciseCount;
    }

    public Element toXml() {
        Element el = new Element("Init");
        el.addContent(this.instructionCommandTitle.toXml("InstructionCommandTitle"));
        el.addContent(this.commandTitle.toXml("CommandTitle"));
        el.addContent(this.commandText.toXml("CommandText"));
        el.addContent(this.questionTitle.toXml("QuestionTitle"));
        el.addContent(this.questionText.toXml("QuestionText"));
        if (this.joystickLabels.size() == 4) {
            this.appendJoystickLabels(el);
        }
        Element eit = new Element("InterferenceTime");
        eit.setText("" + this.interferenceTime);
        el.addContent(eit);
        Element eft = new Element("FeedbackTime");
        eft.setText("" + this.feedbackTime);
        el.addContent(eft);
        Element edt = new Element("DisplayTimer");
        edt.setText("" + this.displayTimer);
        el.addContent(edt);
        Element ednb = new Element("DisplayNextButton");
        ednb.setText("" + this.displayNextButton);
        el.addContent(ednb);
        if (this.randomOperation) {
            Element ero = new Element("RandomOperation");
            ero.setText("" + this.randomOperation);
            el.addContent(ero);
        }
        Element edelt = new Element("TestDelay");
        edelt.setText("" + this.testDelay);
        el.addContent(edelt);
        if (this.randomizedPool) {
            Element erp = new Element("RandomizedPool");
            erp.setAttribute("exerciseCount", "" + this.randomizedPoolExerciseCount);
            erp.setText("true");
            el.addContent(erp);
        }
        return el;
    }

    private void appendJoystickLabels(Element el) {
        Element ejl = new Element("JoystickLabels");
        ejl.addContent(this.joystickLabels.get(0).toXml("Button1"));
        ejl.addContent(this.joystickLabels.get(1).toXml("Button2"));
        ejl.addContent(this.joystickLabels.get(2).toXml("Button3"));
        ejl.addContent(this.joystickLabels.get(3).toXml("Button4"));
        el.addContent(ejl);
    }
}

