/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.memorization.view;

import hsr.pma.app.view.components.ALabel;
import hsr.pma.app.view.components.ATextArea;
import hsr.pma.app.view.components.NextButton;
import hsr.pma.app.view.graphics.ApplicationLayouter;
import hsr.pma.memorization.controller.JoystickListener;
import hsr.pma.memorization.model.InfoSlide;
import hsr.pma.memorization.view.SlidePanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class InfoSlidePanel
extends SlidePanel
implements JoystickListener {
    private static final long serialVersionUID = 1L;
    private final InfoSlide slide;
    private JLabel title;
    private JTextArea text;
    private JButton nextButton;

    public InfoSlidePanel(final InfoSlide slide) {
        this.slide = slide;
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.title = new ALabel(slide.getTitle().getText());
        this.title.setForeground(ApplicationLayouter.COLOR_TITLE);
        this.text = new ATextArea(slide.getText().getText());
        this.nextButton = new NextButton();
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                slide.handleNextPressed();
            }
        });
        this.nextButton.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "next");
        this.nextButton.getActionMap().put("next", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                slide.handleNextPressed();
            }
        });
        this.setLayout(null);
        this.add(this.title);
        this.add(this.text);
        this.add(this.nextButton);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width >= 10 && height >= 110) {
            this.myLayout();
        }
    }

    private void myLayout() {
        this.layouter.layoutTitleTextNextButton(this.title, this.text, this.nextButton, this.slide.getTitle().getFontSize(), this.slide.getText().getFontSize());
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(g);
        this.requestFocusInWindow();
    }

    @Override
    public void joystickButtonPressed(int joystickButton) {
        switch (joystickButton) {
            case 4: {
                if (!this.nextButton.isEnabled()) break;
                this.dispatchActionEvent(this.nextButton);
            }
        }
    }
}

