/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.standalone.model;

import hsr.pma.Language;
import hsr.pma.standalone.model.ApplicationScreen;
import hsr.pma.standalone.model.ControlScreen;
import hsr.pma.standalone.model.EndScreen;
import hsr.pma.standalone.model.Image;
import hsr.pma.standalone.model.LicenseScreen;
import hsr.pma.standalone.model.Padding;
import hsr.pma.standalone.model.ResultScreen;
import hsr.pma.standalone.model.StartScreen;
import hsr.pma.standalone.model.Window;
import org.jdom.Element;

public class Standalone {
    private Language lang = Language.GERMAN;
    private Window window = new Window();
    private StartScreen startScreen;
    private LicenseScreen licenseScreen;
    private ControlScreen controlScreen;
    private ApplicationScreen applicationScreen;
    private ResultScreen resultScreen;
    private EndScreen endScreen;
    private Image contentHeader = new Image();
    private Image contentFooter = new Image();
    private Padding contentPadding = new Padding();
    private Image logo = new Image();

    public Standalone() {
        this.startScreen = new StartScreen(this);
        this.licenseScreen = new LicenseScreen(this);
        this.controlScreen = new ControlScreen(this);
        this.applicationScreen = new ApplicationScreen(this);
        this.resultScreen = new ResultScreen(this);
        this.endScreen = new EndScreen(this);
    }

    public Standalone(Element root) {
        Element einit = root.getChild("Init");
        Element elang = einit.getChild("Language");
        if (elang != null) {
            this.lang = Language.valueOfAbbreviation(elang.getText());
        }
        this.window = new Window(einit.getChild("Window"));
        this.logo = new Image(einit.getChild("Logo"));
        this.startScreen = new StartScreen(root.getChild("StartScreen"), this);
        Element escreens = root.getChild("ContentScreens");
        Element ex = escreens.getChild("Header");
        if (ex != null) {
            this.contentHeader = new Image(ex);
        }
        if ((ex = escreens.getChild("Footer")) != null) {
            this.contentFooter = new Image(ex);
        }
        this.contentPadding = new Padding(escreens.getChild("Padding"));
        this.licenseScreen = new LicenseScreen(escreens.getChild("LicenseScreen"), this);
        this.controlScreen = new ControlScreen(escreens.getChild("ControlScreen"), this);
        this.applicationScreen = new ApplicationScreen(escreens.getChild("ApplicationScreen"), this);
        this.resultScreen = new ResultScreen(escreens.getChild("ResultScreen"), this);
        this.endScreen = new EndScreen(escreens.getChild("EndScreen"), this);
        this.setLanguage(this.lang);
    }

    public void setContentHeaderFilename(String relativePath) {
        this.contentHeader.setImage(relativePath);
    }

    public void setContentFooterFilename(String relativePath) {
        this.contentFooter.setImage(relativePath);
    }

    public Image getLogo() {
        return this.logo;
    }

    public Image getContentHeader() {
        return this.contentHeader;
    }

    public Image getContentFooter() {
        return this.contentFooter;
    }

    public Padding getContentPadding() {
        return this.contentPadding;
    }

    public void setLanguage(Language lang) {
        this.lang = lang;
        this.startScreen.setLanguage(lang);
        this.licenseScreen.setLanguage(lang);
        this.controlScreen.setLanguage(lang);
        this.applicationScreen.setLanguage(lang);
        this.resultScreen.setLanguage(lang);
        this.endScreen.setLanguage(lang);
    }

    public Language getLanguage() {
        return this.lang;
    }

    public Window getWindow() {
        return this.window;
    }

    public StartScreen getStartScreen() {
        return this.startScreen;
    }

    public LicenseScreen getLicenseScreen() {
        return this.licenseScreen;
    }

    public ApplicationScreen getContentScreen() {
        return this.applicationScreen;
    }

    public ControlScreen getControlScreen() {
        return this.controlScreen;
    }

    public ResultScreen getResultScreen() {
        return this.resultScreen;
    }

    public EndScreen getEndScreen() {
        return this.endScreen;
    }

    public Element toXml() {
        Element el = new Element("Standalone");
        Element einit = new Element("Init");
        Element elang = new Element("Language");
        elang.setText(this.lang.abbreviation);
        einit.addContent(this.window.toXml());
        einit.addContent(elang);
        einit.addContent(this.logo.toXml("Logo"));
        el.addContent(einit);
        el.addContent(this.startScreen.toXml());
        Element ecs = new Element("ContentScreens");
        ecs.addContent(this.contentHeader.toXml("Header"));
        ecs.addContent(this.contentFooter.toXml("Footer"));
        ecs.addContent(this.contentPadding.toXml());
        ecs.addContent(this.licenseScreen.toXml());
        ecs.addContent(this.controlScreen.toXml());
        ecs.addContent(this.applicationScreen.toXml());
        ecs.addContent(this.resultScreen.toXml());
        ecs.addContent(this.endScreen.toXml());
        el.addContent(ecs);
        return el;
    }
}

