/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.informationordering.view;

import hsr.pma.app.ITestApplication;
import hsr.pma.app.joystick.ButtonListener;
import hsr.pma.app.view.ObserverArg;
import hsr.pma.app.view.components.AButton;
import hsr.pma.app.view.components.ALabel;
import hsr.pma.app.view.components.NextButton;
import hsr.pma.app.view.graphics.ApplicationLayouter;
import hsr.pma.testapp.informationordering.pd.ActionSlide;
import hsr.pma.testapp.informationordering.pd.Answer;
import hsr.pma.testapp.informationordering.pd.InformationOrdering;
import hsr.pma.testapp.informationordering.view.InformationOrderingLayouter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class ActionSlidePanel
extends JPanel
implements Observer,
ButtonListener {
    private static final long serialVersionUID = 1L;
    private final InformationOrdering model;
    private ActionSlide slide;
    private JButton nextButton = new NextButton();
    private Polygon polygon;
    private ArrayList<JButton> answerButtons = new ArrayList();
    private ArrayList<JLabel> answerLabels = new ArrayList();
    private JLabel title = new ALabel();
    private InformationOrderingLayouter layouter;

    public ActionSlidePanel(InformationOrdering model) {
        this.model = model;
        this.layouter = new InformationOrderingLayouter(this);
        this.setBackground(ApplicationLayouter.COLOR_BACKGROUND);
        this.setOpaque(true);
        this.setLayout(null);
        this.add(this.title);
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ActionSlidePanel.this.handleNextButtonPressed();
            }
        });
        this.add(this.nextButton);
        this.createAnswerButtons();
        this.createKeyStrokeListener();
    }

    private void createAnswerButtons() {
        int i = 0;
        while (i < 4) {
            AButton button = new AButton();
            button.setMargin(new Insets(0, 0, 0, 0));
            button.setEnabled(false);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ActionSlidePanel.this.handleAnswerButtonPressed(arg0.getActionCommand());
                }
            });
            this.add(button);
            this.answerButtons.add(button);
            button.setFocusable(false);
            ALabel label = new ALabel(this.model.getButtonLabels().get(i));
            label.setForeground(ApplicationLayouter.COLOR_TITLE);
            this.add(label);
            this.answerLabels.add(label);
            ++i;
        }
    }

    private void createKeyStrokeListener() {
        int i = 0;
        while (i < this.answerButtons.size()) {
            this.addShortcuts(this.answerButtons.get(i), i);
            ++i;
        }
    }

    private void addShortcuts(JButton button, int i) {
        ButtonActionListener listener = new ButtonActionListener(this);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(116 + i, 0);
        String command = "doClick";
        button.getInputMap(2).put(keyStroke, command);
        button.getActionMap().put(command, listener);
    }

    private void handleAnswerButtonPressed(String text) {
        this.slide.handleAnswerButtonPressed(text);
    }

    public void setSlide(ActionSlide slide) {
        if (this.slide != null) {
            this.slide.deleteObserver(this);
        }
        this.slide = slide;
        this.slide.addObserver(this);
        if (slide.hasNextButton()) {
            this.nextButton.setVisible(true);
            this.nextButton.setEnabled(false);
        } else {
            this.nextButton.setVisible(false);
        }
        this.title.setText(slide.getTitle());
        ArrayList<Answer> answers = slide.getAnswers();
        int i = 0;
        while (i < this.answerButtons.size()) {
            JButton button = this.answerButtons.get(i);
            button.setText("" + answers.get((int)i).number);
            ++i;
        }
        for (JButton button : this.answerButtons) {
            button.setEnabled(true);
        }
        this.myLayout();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width < 10) {
            return;
        }
        if (height < 10) {
            return;
        }
        this.myLayout();
    }

    public void myLayout() {
        this.layouter.layoutTitle(this.title);
        this.layouter.layoutNextButton(this.nextButton);
        this.polygon = this.layouter.createPolygon(this.slide.getSymbol(), false);
        ArrayList<Answer> answers = this.slide.getAnswers();
        this.layouter.layoutAnswerButtons(this.answerButtons, answers, this.answerLabels);
    }

    public void paintComponent(Graphics g) {
        ITestApplication.State appState;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(g);
        Rectangle bounds = this.getBounds();
        if (bounds.width == 0) {
            return;
        }
        if (bounds.height == 0) {
            return;
        }
        this.layouter.paintPolygon(g, this.polygon);
        if (this.slide.getState() == ActionSlide.State.SECOND_BUTTON_PRESSED && (appState = this.model.getState()) == ITestApplication.State.INSTRUCTING) {
            this.showFeedback(g);
        }
    }

    private void showFeedback(Graphics g) {
        String x = this.slide.getFirstAnswer();
        int index = this.findIndexByString(x);
        boolean ok = this.slide.isFirstAnswerOk();
        this.layouter.layoutFeedback(index, ok, g);
        x = this.slide.getSecondAnswer();
        index = this.findIndexByString(x);
        ok = this.slide.isSecondAnswerOk();
        this.layouter.layoutFeedback(index, ok, g);
    }

    private int findIndexByString(String text) {
        JButton search = null;
        for (JButton but : this.answerButtons) {
            if (!but.getText().equals(text)) continue;
            search = but;
        }
        if (search == null) {
            return -1;
        }
        return this.answerButtons.indexOf(search);
    }

    public void handleNextButtonPressed() {
        this.model.showNextSlide();
    }

    public void update(Observable arg0, Object arg1) {
        ObserverArg oa = (ObserverArg)arg1;
        switch (oa.cmd) {
            case 745: {
                this.handleStateChanged((ActionSlide.State)((Object)oa.obj));
                return;
            }
        }
    }

    private void handleStateChanged(ActionSlide.State state) {
        switch (state) {
            case READY: {
                for (JButton but : this.answerButtons) {
                    but.setEnabled(true);
                }
                break;
            }
            case FIRST_BUTTON_PRESSED: {
                String x = this.slide.getFirstAnswer();
                this.disableButton(x);
                break;
            }
            case SECOND_BUTTON_PRESSED: {
                String x = this.slide.getSecondAnswer();
                this.disableButton(x);
                if (this.slide.hasNextButton()) {
                    this.nextButton.setEnabled(true);
                }
                this.repaint();
            }
        }
    }

    private void disableButton(String text) {
        for (JButton but : this.answerButtons) {
            if (!but.getText().equals(text)) continue;
            but.setEnabled(false);
            return;
        }
    }

    public void handleButtonPressed(int joystickButton) {
        switch (joystickButton) {
            case 4: {
                if (!this.slide.hasNextButton() || !this.nextButton.isEnabled()) break;
                this.dispatchActionEvent(this.nextButton);
                break;
            }
            case 0: {
                JButton but = this.answerButtons.get(0);
                if (!but.isEnabled()) break;
                this.dispatchActionEvent(but);
                break;
            }
            case 1: {
                JButton but = this.answerButtons.get(1);
                if (!but.isEnabled()) break;
                this.dispatchActionEvent(but);
                break;
            }
            case 2: {
                JButton but = this.answerButtons.get(2);
                if (!but.isEnabled()) break;
                this.dispatchActionEvent(but);
                break;
            }
            case 3: {
                JButton but = this.answerButtons.get(3);
                if (!but.isEnabled()) break;
                this.dispatchActionEvent(but);
            }
        }
    }

    private void dispatchActionEvent(JButton but) {
        ActionEvent evt = new ActionEvent(but, 1001, but.getActionCommand());
        ActionListener[] actionListenerArray = but.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener listener = actionListenerArray[n2];
            listener.actionPerformed(evt);
            ++n2;
        }
    }

    protected ActionSlide getSlide() {
        return this.slide;
    }

    class ButtonActionListener
    extends AbstractAction
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private ActionSlidePanel panel;

        public ButtonActionListener(ActionSlidePanel panel) {
            this.panel = panel;
        }

        public void actionPerformed(ActionEvent e) {
            this.panel.handleAnswerButtonPressed(((JButton)e.getSource()).getText());
        }
    }
}

