/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.informationordering.view;

import hsr.pma.app.joystick.ButtonListener;
import hsr.pma.app.view.components.ALabel;
import hsr.pma.app.view.components.ATextArea;
import hsr.pma.app.view.components.NextButton;
import hsr.pma.app.view.graphics.ApplicationLayouter;
import hsr.pma.testapp.informationordering.pd.InfoSlide;
import hsr.pma.testapp.informationordering.view.InformationOrderingLayouter;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class InfoSlidePanel
extends JPanel
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private InfoSlide slide;
    private JLabel title = new ALabel();
    private JTextArea area = new ATextArea();
    private JButton nextButton = new NextButton();
    private InformationOrderingLayouter layouter = new InformationOrderingLayouter(this);

    public InfoSlidePanel() {
        this.setBackground(ApplicationLayouter.COLOR_BACKGROUND);
        this.setOpaque(true);
        this.setLayout(null);
        this.add(this.title);
        this.add(this.area);
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfoSlidePanel.this.handleNextButtonPressed();
            }
        });
        this.add(this.nextButton);
    }

    public void setSlide(InfoSlide slide) {
        this.slide = slide;
        this.area.setText(slide.getText());
        this.title.setText(slide.getTitle());
        if (slide.hasNextButton()) {
            this.nextButton.setVisible(true);
        } else {
            this.nextButton.setVisible(false);
        }
        this.layouter.layoutTitleTextNextButton(this.title, this.area, this.nextButton);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width < 10) {
            return;
        }
        if (height < 10) {
            return;
        }
        this.layouter.layoutTitleTextNextButton(this.title, this.area, this.nextButton);
    }

    public void handleNextButtonPressed() {
        this.slide.handleNextPressed();
    }

    public void handleButtonPressed(int joystickButton) {
        switch (joystickButton) {
            case 4: {
                if (!this.slide.hasNextButton() || !this.nextButton.isEnabled()) break;
                this.dispatchActionEvent(this.nextButton);
            }
        }
    }

    private void dispatchActionEvent(JButton but) {
        but.getModel().setArmed(true);
        but.getModel().setPressed(true);
        Dimension d = but.getSize();
        but.paintImmediately(0, 0, d.width, d.height);
        ActionEvent evt = new ActionEvent(but, 1001, but.getActionCommand());
        ActionListener[] actionListenerArray = but.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener listener = actionListenerArray[n2];
            listener.actionPerformed(evt);
            ++n2;
        }
        but.getModel().setArmed(false);
        but.getModel().setPressed(false);
    }
}

