/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.informationordering.view;

import hsr.pma.app.joystick.ButtonListener;
import hsr.pma.app.view.ObserverArg;
import hsr.pma.testapp.informationordering.pd.ActionSlide;
import hsr.pma.testapp.informationordering.pd.ExampleSlide;
import hsr.pma.testapp.informationordering.pd.InfoSlide;
import hsr.pma.testapp.informationordering.pd.InformationOrdering;
import hsr.pma.testapp.informationordering.pd.ResultSlide;
import hsr.pma.testapp.informationordering.pd.Slide;
import hsr.pma.testapp.informationordering.view.ActionSlidePanel;
import hsr.pma.testapp.informationordering.view.ExampleSlidePanel;
import hsr.pma.testapp.informationordering.view.InfoSlidePanel;
import hsr.pma.testapp.informationordering.view.ResultSlidePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;

public class InformationOrderingPanel
extends JPanel
implements Observer,
ButtonListener {
    private static final long serialVersionUID = 1L;
    public final InformationOrdering model;
    private InfoSlidePanel infoPanel;
    private ExampleSlidePanel examplePanel;
    private ActionSlidePanel actionPanel;
    private ResultSlidePanel resultPanel;
    private ButtonListener activePanel;

    public InformationOrderingPanel(InformationOrdering model) {
        this.model = model;
        this.model.addObserver(this);
        this.setLayout(new BorderLayout());
        this.infoPanel = new InfoSlidePanel();
        this.examplePanel = new ExampleSlidePanel(model);
        this.actionPanel = new ActionSlidePanel(model);
        this.resultPanel = new ResultSlidePanel(model);
    }

    public void update(Observable o, Object arg) {
        ObserverArg oa = (ObserverArg)arg;
        switch (oa.cmd) {
            case 600: {
                this.handleShowSlide((Slide)oa.obj);
                return;
            }
            case 601: {
                this.handleButtonPressed((Integer)oa.obj);
                return;
            }
        }
    }

    private void handleShowSlide(Slide slide) {
        if (slide instanceof ResultSlide) {
            this.resultPanel.setSlide((ResultSlide)slide);
            this.setPanel(this.resultPanel);
            return;
        }
        if (slide instanceof ActionSlide) {
            this.actionPanel.setSlide((ActionSlide)slide);
            this.setPanel(this.actionPanel);
            return;
        }
        if (slide instanceof ExampleSlide) {
            this.examplePanel.setSlide((ExampleSlide)slide);
            this.setPanel(this.examplePanel);
            return;
        }
        if (slide instanceof InfoSlide) {
            this.infoPanel.setSlide((InfoSlide)slide);
            this.setPanel(this.infoPanel);
            return;
        }
    }

    public void handleButtonPressed(int joystickButton) {
        if (this.activePanel == null) {
            return;
        }
        this.activePanel.handleButtonPressed(joystickButton);
    }

    private void setPanel(JPanel panel) {
        this.removeAll();
        this.add((Component)panel, "Center");
        this.validate();
        this.activePanel = (ButtonListener)((Object)panel);
        this.repaint();
        if (panel instanceof ActionSlidePanel) {
            ((ActionSlidePanel)panel).getSlide().setStarted();
        }
    }
}

