/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.util;

import java.io.Serializable;
import java.util.Calendar;
import java.util.StringTokenizer;

public class Time
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MILLIS_PER_SEC = 1000;
    private static final int MILLIS_PER_MIN = 60000;
    private static final int MILLIS_PER_HOUR = 3600000;
    private static final char DELIM_1 = ':';
    private static final char DELIM_2 = '.';
    public static final long MAX_TIME = 86399999L;
    public static final long MILLIS_PER_DAY = 86400000L;
    private final long time;

    public Time() {
        this.time = 0L;
    }

    public Time(long millis) {
        this.time = millis % 86400000L;
    }

    public static Time create(long systemTimeInMillis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(systemTimeInMillis);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        int ms = cal.get(14);
        int time = hour * 3600000 + min * 60000 + sec * 1000 + ms;
        return new Time(time);
    }

    public Time(String timestamp) {
        if (timestamp.equals("00:00:00.000")) {
            this.time = 0L;
            return;
        }
        try {
            StringTokenizer st = new StringTokenizer(timestamp, ":");
            String hours = st.nextToken();
            int hour = Integer.parseInt(hours);
            if (hour < 0 || hour > 23) {
                throw new IllegalArgumentException("hour out of scope: " + hour);
            }
            String mins = st.nextToken();
            int min = Integer.parseInt(mins);
            if (min < 0 || min > 59) {
                throw new IllegalArgumentException("min out of scope: " + hour);
            }
            String rest = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(rest, ".");
            String secs = st2.nextToken();
            int sec = Integer.parseInt(secs);
            if (sec < 0 || sec > 59) {
                throw new IllegalArgumentException("sec out of scope: " + sec);
            }
            String mss = st2.nextToken();
            int ms = Integer.parseInt(mss);
            if (ms < 0 || ms > 999) {
                throw new IllegalArgumentException("ms out of scope: " + sec);
            }
            this.time = hour * 3600000 + min * 60000 + sec * 1000 + ms;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Timestamp could not be parsed: " + timestamp, e);
        }
    }

    public long getMillis() {
        return this.time;
    }

    public String toString() {
        int hour = (int)this.time / 3600000;
        int rest = (int)(this.time % 3600000L);
        int min = rest / 60000;
        int sec = (rest %= 60000) / 1000;
        int ms = rest % 1000;
        StringBuilder sb = new StringBuilder();
        sb.append(this.addZeros(hour, 2));
        sb.append(':');
        sb.append(this.addZeros(min, 2));
        sb.append(':');
        sb.append(this.addZeros(sec, 2));
        sb.append('.');
        sb.append(this.addZeros(ms, 3));
        return sb.toString();
    }

    private String addZeros(int number, int digits) {
        String result = "" + number;
        switch (digits) {
            case 2: {
                if (number < 0 || number > 99) {
                    throw new IllegalArgumentException("Number cannot be displayed correctly: number=" + number + " digits=" + digits);
                }
                if (result.length() != 1) break;
                result = "0" + result;
                break;
            }
            case 3: {
                if (number < 0 || number > 999) {
                    throw new IllegalArgumentException("Number cannot be displayed correctly: number=" + number + " digits=" + digits);
                }
                if (result.length() == 1) {
                    result = "00" + result;
                    break;
                }
                if (result.length() != 2) break;
                result = "0" + result;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Argument: digits=" + digits);
            }
        }
        return result;
    }
}

