/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.app.time;

import hsr.pma.app.time.TimeoutListener;

public class TimeoutThread
extends Thread {
    public static final boolean DEBUG = false;
    public final int delay;
    public final TimeoutListener listener;

    public TimeoutThread(int delay, TimeoutListener listener) {
        if (delay < 1) {
            throw new IllegalArgumentException("TimeoutThread delay=" + delay);
        }
        if (listener == null) {
            throw new IllegalArgumentException("TimeoutThread listener null");
        }
        this.delay = delay;
        this.listener = listener;
        this.setName("TimeoutThread");
    }

    @Override
    public void run() {
        try {
            TimeoutThread.sleep(this.delay);
        }
        catch (InterruptedException e) {
            return;
        }
        this.listener.timeoutReached();
    }

    public void dispose() {
        Thread.State state = this.getState();
        switch (state) {
            case TIMED_WAITING: {
                this.interrupt();
                break;
            }
        }
    }
}

