/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.app.view.graphics;

import hsr.pma.app.view.graphics.GraphicsContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ApplicationLayouter {
    public static final Color COLOR_BACKGROUND = Color.WHITE;
    public static final Color COLOR_TEXT = Color.BLACK;
    public static final Color COLOR_TITLE = new Color(0, 78, 152);
    public static final Color COLOR_RED = new Color(226, 11, 11);
    public static final Color COLOR_GREEN = new Color(31, 133, 39);
    public static final int FONT_SIZE_TITLE = 130;
    public static final int FONT_SIZE_TEXT = 100;
    protected final JPanel panel;
    protected GraphicsContext gc;

    public ApplicationLayouter(JPanel panel) {
        this.panel = panel;
        this.gc = this.createGraphicsContext(panel);
    }

    protected GraphicsContext createGraphicsContext(JPanel panel) {
        return new GraphicsContext(panel);
    }

    public GraphicsContext getGraphicsContext() {
        return this.gc;
    }

    public void layoutNextButton(JButton but) {
        Dimension d = this.gc.getSize();
        Insets b = this.gc.getBorder();
        int bs = this.gc.getButtonSize();
        but.setBounds(d.width - b.left - bs, d.height - b.bottom - bs, bs, bs);
    }

    public int layoutTitle(JComponent cmp) {
        return this.layoutTitle(cmp, 130);
    }

    public int layoutTitle(JComponent cmp, int fontSize) {
        cmp.setFont(this.gc.getFontBold(fontSize));
        cmp.setForeground(COLOR_TITLE);
        Insets b = this.gc.getBorder();
        Dimension d = this.gc.getSize();
        cmp.setSize(new Dimension(d.width - b.left - b.right, 0));
        int height = cmp.getPreferredSize().height;
        cmp.setBounds(b.left, b.top, d.width - b.left - b.right, height);
        return height;
    }

    public int layoutText(JComponent cmp, int yOffset) {
        return this.layoutText(cmp, yOffset, 100);
    }

    public int layoutText(JComponent cmp, int yOffset, int fontSize) {
        cmp.setFont(this.gc.getFont(fontSize));
        Insets b = this.gc.getBorder();
        Dimension d = this.gc.getSize();
        cmp.setSize(new Dimension(d.width - b.left - b.right, 0));
        int height = cmp.getPreferredSize().height;
        cmp.setBounds(b.left, yOffset, d.width - b.left - b.right, height);
        return height;
    }

    public void layoutTitleTextNextButton(JComponent title, JComponent text, JButton nextButton, int fontSizeTitle, int fontSizeText) {
        int titleHeight = this.layoutTitle(title, fontSizeTitle);
        int ygap = this.gc.getTitleTextYGap();
        int yOffset = this.gc.getBorder().top + titleHeight + ygap;
        this.layoutText(text, yOffset, fontSizeText);
        this.layoutNextButton(nextButton);
    }

    public void layoutTitleTextNextButton(JComponent title, JComponent text, JButton nextButton) {
        this.layoutTitleTextNextButton(title, text, nextButton, 130, 100);
    }

    public void layoutProgressBar(JProgressBar bar) {
        bar.setFont(this.gc.getFontBold(130));
        int bwidth = this.gc.getSize().width - this.gc.getBorder().left - this.gc.getBorder().right;
        int bheight = this.gc.getButtonSize();
        int x = this.gc.getBorder().left;
        int y = (this.gc.getSize().height - bheight) / 2;
        bar.setBounds(x, y, bwidth, bheight);
    }
}

