/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.standalone.view;

import hsr.pma.standalone.Locator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JFrame;

public class GraphicsContext {
    public static final Color COLOR_TITLE = new Color(0, 78, 152);
    private static final String FONT_FAMILY = "Tahoma";
    private static double GRID = 0.1;
    private static double SCALE_NEXT_BUTTON = 1.0;
    private static double SCALE_BUTTON = 0.7;
    private static double SCALE_FONT_SIZE_100 = 0.375;
    private static double SCALE_UNIT = 0.5;
    private static double SCALE_TITLE_TEXT_Y_GAP = 0.25;

    public Font getFont(int fontSize) {
        int size = this.getFonSizeInPixel(fontSize);
        return new Font(FONT_FAMILY, 0, size);
    }

    public Font getFontBold(int fontSize) {
        int size = this.getFonSizeInPixel(fontSize);
        return new Font(FONT_FAMILY, 1, size);
    }

    private int getFonSizeInPixel(int fontSize) {
        return (int)((double)fontSize / 100.0 * this.getGrid() * SCALE_FONT_SIZE_100);
    }

    public int getUnit() {
        return (int)(this.getGrid() * SCALE_UNIT);
    }

    public int getTitleTextYGap() {
        return (int)(this.getGrid() * SCALE_TITLE_TEXT_Y_GAP);
    }

    public int getButtonHeight() {
        return (int)(this.getGrid() * SCALE_BUTTON);
    }

    public int getNextButtonHeight() {
        return (int)(this.getGrid() * SCALE_NEXT_BUTTON);
    }

    private double getGrid() {
        return Math.sqrt(this.getWidth() * this.getHeight()) * GRID;
    }

    public int getWidth() {
        JFrame frame = this.getFrame();
        if (frame == null) {
            System.err.println("[GraphicsContext] frame is null");
            return 200;
        }
        Dimension size = frame.getSize();
        Insets insets = frame.getInsets();
        return size.width - insets.left - insets.right;
    }

    public int getHeight() {
        JFrame frame = this.getFrame();
        if (frame == null) {
            System.err.println("[GraphicsContext] frame is null");
            return 200;
        }
        Dimension size = frame.getSize();
        Insets insets = frame.getInsets();
        return size.height - insets.top - insets.bottom;
    }

    private JFrame getFrame() {
        return Locator.getFrame();
    }
}

