/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.standalone.view;

import hsr.pma.standalone.Locator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class ImageProvider {
    private static boolean DEBUG = false;
    public static String IMAGE_DIR = "images/";
    public static String BASE_DIR = "";
    private ImageCache<String, Image> hash = new ImageCache(15, 0.75f, true);
    private boolean withinJar = false;

    public ImageProvider() {
        String x = ImageProvider.class.getResource("ImageProvider.class").toString();
        this.withinJar = x.startsWith("jar");
    }

    public Image getScaledImage(String imageName) {
        int width = this.getWidth();
        String key = String.valueOf(imageName) + "-" + width;
        Image cached = (Image)this.hash.get(key);
        if (cached != null) {
            if (DEBUG) {
                System.out.println("[ImageProvider] found in cache: " + key);
            }
            return cached;
        }
        BufferedImage img = this.getImage(imageName);
        Image scaledImage = this.scaleImage(img, width);
        this.hash.put(key, scaledImage);
        if (DEBUG) {
            System.out.println("[ImageProvider] put to cache: " + key + " size cache: " + this.hash.size() + " width=" + width + " height=" + scaledImage.getHeight(null));
        }
        return scaledImage;
    }

    public Image scaleImage(BufferedImage img, int width) {
        int height = img.getHeight() * width / img.getWidth();
        Image scaledImage = img.getScaledInstance(width, height, 4);
        BufferedImage imageBuff = new BufferedImage(width, height, 1);
        Graphics2D g = imageBuff.createGraphics();
        g.drawImage(scaledImage, 0, 0, new Color(0, 0, 0), null);
        g.dispose();
        return scaledImage;
    }

    public Image getImage(File file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            BufferedImage img = ImageIO.read(in);
            if (DEBUG) {
                System.out.println("[ImageProvider] image read from file: " + file);
            }
            BufferedImage bufferedImage = img;
            return bufferedImage;
        }
        catch (Exception e) {
            throw new RuntimeException("[ImageProvider] could not load: " + file);
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferedImage getImage(String filename) {
        InputStream in = null;
        try {
            if (this.withinJar) {
                in = ClassLoader.getSystemClassLoader().getResourceAsStream(filename);
                if (in == null) {
                    throw new RuntimeException("[ImageProvider] imgage not found in jar: " + filename);
                }
                BufferedImage img = ImageIO.read(in);
                if (DEBUG) {
                    System.out.println("[ImageProvider] image read from jar: " + filename);
                }
                BufferedImage bufferedImage = img;
                return bufferedImage;
            }
            String filepath = this.getFilepath(filename);
            File file = new File(filepath);
            if (file.exists()) {
                in = new FileInputStream(file);
                BufferedImage img = ImageIO.read(in);
                if (DEBUG) {
                    System.out.println("[ImageProvider] file read from file: " + file);
                }
                BufferedImage bufferedImage = img;
                return bufferedImage;
            }
            throw new RuntimeException("[ImageProvider] could not load: " + filepath);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    private int getWidth() {
        return Locator.getGraphicsContext().getWidth();
    }

    private String getFilepath(String filename) {
        return String.valueOf(BASE_DIR) + filename;
    }

    private class ImageCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private static final int MAX_ITEMS = 10;

        public ImageCache(int initialCapacity, float loadFactor, boolean accessOrder) {
            super(initialCapacity, loadFactor, accessOrder);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 10;
        }
    }
}

