/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.selectiveAttention.app;

import hsr.pma.Language;
import hsr.pma.testapp.selectiveAttention.app.Application;
import hsr.pma.testapp.selectiveAttention.app.RandomizedStepGenerator;
import hsr.pma.testapp.selectiveAttention.pd.FeedbackStep;
import hsr.pma.testapp.selectiveAttention.pd.ResultStep;
import hsr.pma.testapp.selectiveAttention.pd.RuleStep;
import hsr.pma.testapp.selectiveAttention.pd.Step;
import hsr.pma.testapp.selectiveAttention.pd.TestStep;
import hsr.pma.testapp.selectiveAttention.pd.TestsequenceStep;
import hsr.pma.testapp.selectiveAttention.pd.TitelStep;
import hsr.pma.testapp.selectiveAttention.pd.TitelTextStep;
import hsr.pma.testapp.selectiveAttention.pd.VolumeStep;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int reactionGap;
    private int feedbackGap;
    private int ruleGap;
    private String volumeCombination;
    private Application app;
    private Element configuration;
    private RandomizedStepGenerator generator;
    private ArrayList<Step> instructionSteps = new ArrayList();
    private boolean randomizedPool = false;
    private int randomizedPoolExerciseCount = 10;
    private Random rand = new Random(System.currentTimeMillis());
    private int multiTestIndex = 0;
    private Language lang = Language.GERMAN;

    public StepFactory() {
    }

    public StepFactory(Application app, Element configuration) throws RuntimeException {
        this.app = app;
        this.configuration = configuration;
        this.generator = new RandomizedStepGenerator(this.app);
        this.parseInit(configuration.getChild("Init"));
    }

    public Element getPreparedTestElement() {
        List etests = this.configuration.getChildren("Test");
        Element etest = (Element)etests.get(this.multiTestIndex);
        if (!this.randomizedPool) {
            return etest;
        }
        ArrayList<Element> tsteps = new ArrayList<Element>();
        for (Object o : etest.getChildren()) {
            Element estep = (Element)o;
            if (!estep.getName().equals("TestStep")) continue;
            tsteps.add((Element)estep.clone());
        }
        Collections.shuffle(tsteps, this.rand);
        Element result = new Element("Test");
        int tcount = 0;
        int index = 0;
        while (true) {
            Element step;
            if (!(step = (Element)etest.getChildren().get(index)).getName().equals("TestStep")) {
                result.addContent((Element)step.clone());
                ++index;
                continue;
            }
            result.addContent((Content)tsteps.remove(tsteps.size() - 1));
            if (++tcount == this.randomizedPoolExerciseCount || ++index == etest.getChildren().size()) break;
        }
        while (index < etest.getChildren().size()) {
            Element firstStep = (Element)etest.getChildren().get(index);
            if (firstStep.getName().equals("TestStep")) {
                ++index;
                continue;
            }
            Element secondStep = null;
            if (++index < etest.getChildren().size()) {
                secondStep = (Element)etest.getChildren().get(index);
            }
            if (secondStep == null) {
                result.addContent((Element)firstStep.clone());
                break;
            }
            if (secondStep.getName().equals("TestStep")) {
                ++index;
                continue;
            }
            result.addContent(firstStep);
            result.addContent(secondStep);
        }
        return result;
    }

    public void setLanguage(Language lang) {
        Element eInstruction = this.configuration.getChild("Instruction");
        this.instructionSteps = this.parseInstruction(eInstruction, lang);
        this.lang = lang;
    }

    public int getTestCount() {
        return this.configuration.getChildren("Test").size();
    }

    public void setTest(int index) {
        this.multiTestIndex = index;
    }

    private ArrayList<Step> parseInstruction(Element etest, Language lang) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (Object obj : etest.getChildren()) {
            Element estep = (Element)obj;
            if (estep.getName().equals("InstructionStep")) {
                steps.add(this.createTitelTextStep(estep, lang));
                continue;
            }
            if (estep.getName().equals("TitleStep")) {
                steps.add(this.createTitelStep(estep, lang));
                continue;
            }
            if (estep.getName().equals("VolumeStep")) {
                steps.add(this.createVolumeStep(estep, lang));
                continue;
            }
            if (estep.getName().equals("ExerciseStep")) {
                String[] criticals = this.split(estep.getChildText("Critical"));
                steps.add(this.createRuleStep(estep, criticals, lang));
                String[] combinations = this.split(estep.getChildText("Combination"));
                int i = 0;
                while (i < combinations.length) {
                    TestStep ts = new TestStep(combinations[i], this.reactionGap, this.isCritical(criticals, combinations[i]));
                    steps.add(ts);
                    steps.add(new FeedbackStep(ts, this.feedbackGap));
                    ++i;
                }
                continue;
            }
            if (estep.getName().equals("RandomizedExerciseStep")) {
                this.appendRandomisedExerciseSteps(estep, lang, steps, true);
                continue;
            }
            System.err.println("undefined step: " + estep.getName());
        }
        Step lastStep = (Step)steps.get(steps.size() - 1);
        if (lastStep instanceof TitelStep) {
            ((TitelStep)lastStep).setHasNext(false);
        }
        return steps;
    }

    private ArrayList<Step> parseTest(Element etest, Language lang) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (Object obj : etest.getChildren()) {
            Element estep = (Element)obj;
            if (estep.getName().equals("InstructionStep")) {
                steps.add(this.createTitelTextStep(estep, lang));
                continue;
            }
            if (estep.getName().equals("TitleStep")) {
                steps.add(this.createTitelStep(estep, lang));
                continue;
            }
            if (estep.getName().equals("VolumeStep")) {
                steps.add(this.createVolumeStep(estep, lang));
                continue;
            }
            if (estep.getName().equals("TestStep")) {
                String[] criticals = this.split(estep.getChildText("Critical"));
                steps.add(this.createRuleStep(estep, criticals, lang));
                String[] combinations = this.split(estep.getChildText("Combination"));
                ArrayList<TestStep> teststeps = new ArrayList<TestStep>();
                int i = 0;
                while (i < combinations.length) {
                    TestStep ts = new TestStep(combinations[i], this.reactionGap, this.isCritical(criticals, combinations[i]));
                    steps.add(ts);
                    teststeps.add(ts);
                    ++i;
                }
                steps.add(new TestsequenceStep(teststeps.toArray(new TestStep[teststeps.size()]), this.app));
                continue;
            }
            if (estep.getName().equals("RandomizedExerciseStep")) {
                this.appendRandomisedExerciseSteps(estep, lang, steps, false);
                continue;
            }
            if (estep.getName().equals("ResultStep")) {
                steps.add(this.createResultStep(estep, lang));
                continue;
            }
            System.err.println("undefined step: " + estep.getName());
        }
        Step lastStep = (Step)steps.get(steps.size() - 1);
        if (lastStep instanceof TitelStep) {
            ((TitelStep)lastStep).setHasNext(false);
        }
        return steps;
    }

    public List<Step> getInstructionSteps() {
        return this.instructionSteps;
    }

    public List<Step> getTestSteps() {
        Element etest = this.getPreparedTestElement();
        return this.parseTest(etest, this.lang);
    }

    private TitelTextStep createTitelTextStep(Element e, Language lang) {
        String text;
        String title = e.getChild("Title").getChildText(lang.abbreviation);
        if (title == null) {
            title = "UNDEFINED";
        }
        if ((text = e.getChild("Text").getChildText(lang.abbreviation)) == null) {
            text = "UNDEFINED";
        }
        return new TitelTextStep(title, text);
    }

    private TitelStep createTitelStep(Element e, Language lang) {
        String title = e.getChildText(lang.abbreviation);
        if (title == null) {
            title = "UNDEFINED";
        }
        return new TitelStep(title);
    }

    private VolumeStep createVolumeStep(Element e, Language lang) {
        String text = e.getChildText(lang.abbreviation);
        if (text == null) {
            text = "UNDEFINED";
        }
        return new VolumeStep(text, this.volumeCombination);
    }

    private ResultStep createResultStep(Element e, Language lang) {
        String text = e.getChildText(lang.abbreviation);
        if (text == null) {
            text = "UNDEFINED";
        }
        return new ResultStep(text);
    }

    private RuleStep createRuleStep(Element e, String[] criticals, Language lang) {
        String text = e.getChildText(lang.abbreviation);
        if (text == null) {
            text = "UNDEFINED";
        }
        return new RuleStep(text, criticals, this.ruleGap);
    }

    private void appendRandomisedExerciseSteps(Element node, Language lang, List<Step> steps, boolean instruction) {
        Element alphabetElem = node.getChild("Alphabet");
        Element criticalElem = node.getChild("Critical");
        Element frequencyElem = node.getChild("Frequency");
        Element testStepQuantityElem = node.getChild("TestStepQuantity");
        int critical = Integer.parseInt(criticalElem.getText());
        int frequency = Integer.parseInt(frequencyElem.getText());
        int testStepQuantity = Integer.parseInt(testStepQuantityElem.getText());
        String ruleStepText = node.getChild(lang.abbreviation).getText();
        if (ruleStepText == null) {
            ruleStepText = "UNDEFINED";
        }
        if (instruction) {
            steps.addAll(this.generator.buildExercisesequence(alphabetElem.getText(), this.reactionGap, this.feedbackGap, critical, frequency, testStepQuantity, ruleStepText, this.ruleGap, true));
        } else {
            steps.addAll(this.generator.buildExercisesequence(alphabetElem.getText(), this.reactionGap, this.feedbackGap, critical, frequency, testStepQuantity, ruleStepText, this.ruleGap, false));
        }
    }

    private String[] split(String sequences) {
        String[] combinations = sequences.split(",");
        int i = 0;
        while (i < combinations.length) {
            combinations[i] = combinations[i].trim();
            ++i;
        }
        return combinations;
    }

    private void parseInit(Element init) {
        this.reactionGap = Integer.parseInt(init.getChild("ReactionGap").getText());
        this.feedbackGap = Integer.parseInt(init.getChild("FeedbackGap").getText());
        this.ruleGap = Integer.parseInt(init.getChild("RuleGap").getText());
        this.volumeCombination = init.getChild("VolumeCombination").getText();
        if (init.getChild("RandomizedPool") != null) {
            Element erp = init.getChild("RandomizedPool");
            this.randomizedPool = Boolean.parseBoolean(erp.getText());
            this.randomizedPoolExerciseCount = Integer.parseInt(erp.getAttributeValue("exerciseCount"));
        }
    }

    private boolean isCritical(String[] critical, String combination) {
        String[] stringArray = critical;
        int n = critical.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (c.equals(combination)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

