/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.selectiveAttention.pd;

import hsr.pma.app.ResultStep;
import hsr.pma.testapp.selectiveAttention.app.Application;
import hsr.pma.testapp.selectiveAttention.pd.TestStepResult;
import hsr.pma.util.Time;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Result
extends ResultStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static boolean DEBUG = false;
    public static final String CLASS_NAME = "hsr.pma.testapp.selectiveAttention.pd.Result";
    private static final int FACTOR_MILLION = 1000000;
    private static final String STEP_TAG = "Step";
    private static final String REACTIONTIME_TAG = "Reactiontime";
    private static final String TYPE_TAG = "Type";
    private static final String COMBINATION_TAG = "Combination";
    private static final String RESULT_STEP_TAG = "ResultStep";
    private TestStepResult[] results;

    public Result(TestStepResult[] results, Time started) {
        this.results = results;
        this.started = started;
    }

    public Result(TestStepResult[] results, Application app, Time started) {
        this.results = results;
        this.started = started;
        app.fireResult(this);
        if (DEBUG) {
            System.out.println(this);
        }
    }

    public Element toXML() {
        Element e = new Element(RESULT_STEP_TAG);
        e.setAttribute("time", this.started.toString());
        TestStepResult[] testStepResultArray = this.results;
        int n = this.results.length;
        int n2 = 0;
        while (n2 < n) {
            TestStepResult r = testStepResultArray[n2];
            Element step = new Element(STEP_TAG);
            step.setAttribute("time", r.getStarted().toString());
            Element combination = new Element(COMBINATION_TAG);
            combination.setText(r.getCombination());
            step.addContent(combination);
            Element type = new Element(TYPE_TAG);
            type.setText(r.getType().name());
            step.addContent(type);
            Element reactiontime = new Element(REACTIONTIME_TAG);
            if (r.getReactiontimeInNanos() >= 0L) {
                reactiontime.setText("" + r.getReactiontimeInNanos() / 1000000L);
            }
            step.addContent(reactiontime);
            e.addContent(step);
            ++n2;
        }
        return e;
    }

    public static Result fromXML(Element element) {
        List steps = element.getChildren();
        ArrayList<TestStepResult> results = new ArrayList<TestStepResult>();
        Time started = new Time();
        String x = element.getAttributeValue("time");
        if (x != null && x.length() > 0) {
            started = new Time(x);
        }
        for (Object o : steps) {
            Element e = (Element)o;
            String combination = e.getChild(COMBINATION_TAG).getText();
            TestStepResult.Resulttype type = TestStepResult.Resulttype.valueOf(e.getChild(TYPE_TAG).getText());
            long reactiontime = -1L;
            if (!e.getChild(REACTIONTIME_TAG).getText().equals("")) {
                reactiontime = Long.parseLong(e.getChild(REACTIONTIME_TAG).getText()) * 1000000L;
            }
            Time startTime = new Time();
            Element etime = e.getChild("StartTime");
            if (etime != null) {
                String time = etime.getText();
                String millis = etime.getAttributeValue("millis");
                startTime = new Time(String.valueOf(time) + "." + millis);
            }
            if ((x = e.getAttributeValue("time")) != null && x.length() > 0) {
                startTime = new Time(x);
            }
            results.add(new TestStepResult(combination, type, reactiontime, startTime));
        }
        TestStepResult[] ret = results.toArray(new TestStepResult[results.size()]);
        Result res = new Result(ret, started);
        res.setStarted(started);
        return res;
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public String toString() {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        return outputter.outputString(this.toXML());
    }

    public TestStepResult[] getResult() {
        return this.results;
    }
}

