/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.selectiveAttention.sound;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoundLoader {
    public static boolean DEBUG = true;
    private static final String DIR = "kevin/";
    private static final String CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String gap = "gap";

    public Hashtable<String, byte[]> load() {
        Hashtable<String, byte[]> result = new Hashtable<String, byte[]>();
        char[] cArray = CHARS.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            String filename = DIR + c + ".wav";
            result.put("" + c, this.loadData(filename.toLowerCase()));
            ++n2;
        }
        result.put(" ", this.loadData("kevin/gap.wav"));
        return result;
    }

    private byte[] loadData(String filename) {
        InputStream in = null;
        ByteArrayOutputStream ous = null;
        try {
            in = ClassLoader.getSystemClassLoader().getResourceAsStream(filename);
            if (in == null) {
                if (DEBUG) {
                    System.out.println("[SoundLoader] sound not found in jar: " + filename);
                }
                in = new FileInputStream(new File(filename));
            } else if (DEBUG) {
                System.out.println("[SoundLoader] sound loaded from jar: " + filename);
            }
            byte[] buffer = new byte[4096];
            ous = new ByteArrayOutputStream();
            int read = 0;
            while ((read = in.read(buffer)) != -1) {
                ous.write(buffer, 0, read);
            }
            byte[] byArray = ous.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("[SoundLoader] could not load: " + filename);
        }
        finally {
            try {
                in.close();
                ous.close();
            }
            catch (IOException iOException) {}
        }
    }
}

