/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.selectiveAttention.ui;

import hsr.pma.app.joystick.ButtonListener;
import hsr.pma.app.view.components.ALabel;
import hsr.pma.app.view.components.NextButton;
import hsr.pma.app.view.graphics.ApplicationLayouter;
import hsr.pma.testapp.selectiveAttention.app.StepHandler;
import hsr.pma.testapp.selectiveAttention.ui.ProgressBarAnimator;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ResultPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton button = new NextButton();
    private boolean hasNext;
    protected StepHandler stepHandler;
    private JProgressBar progressBar;
    private JLabel titleLabel = new ALabel();
    private ApplicationLayouter layouter;

    public ResultPanel(StepHandler handler, String title, int value, boolean hasNext) {
        this.setLayout(null);
        this.setOpaque(true);
        this.setBackground(ApplicationLayouter.COLOR_BACKGROUND);
        this.hasNext = hasNext;
        this.stepHandler = handler;
        this.layouter = new ApplicationLayouter(this);
        this.titleLabel.setText(title);
        this.add(this.titleLabel);
        this.initializeComponents();
        this.initializeButton();
        ProgressBarAnimator pba = new ProgressBarAnimator(this.progressBar, value);
        pba.start();
        this.myLayout();
    }

    private void initializeComponents() {
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(30);
        this.progressBar.setStringPainted(true);
        this.progressBar.setForeground(ApplicationLayouter.COLOR_TITLE);
        this.progressBar.setBackground(ApplicationLayouter.COLOR_BACKGROUND);
        this.progressBar.setBorder(BorderFactory.createLineBorder(ApplicationLayouter.COLOR_TITLE));
        this.add(this.progressBar);
    }

    private void initializeButton() {
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ResultPanel.this.stepHandler.nextStep();
            }
        });
        this.stepHandler.setButtonListener(new ButtonListener(){

            public void handleButtonPressed(int b) {
                if (ResultPanel.this.hasNext && b == 4 && ResultPanel.this.button.isEnabled()) {
                    ResultPanel.this.dispatchActionEventPaint(ResultPanel.this.button);
                }
            }
        });
        this.button.setVisible(this.hasNext);
        this.add(this.button);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width < 10) {
            return;
        }
        if (height < 10) {
            return;
        }
        this.myLayout();
    }

    private void myLayout() {
        this.layouter.layoutTitle(this.titleLabel);
        this.layouter.layoutNextButton(this.button);
        this.layouter.layoutProgressBar(this.progressBar);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    private void dispatchActionEventPaint(JButton but) {
        but.getModel().setArmed(true);
        but.getModel().setPressed(true);
        Dimension d = but.getSize();
        but.paintImmediately(0, 0, d.width, d.height);
        ActionEvent evt = new ActionEvent(but, 1001, but.getActionCommand());
        ActionListener[] actionListenerArray = but.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener listener = actionListenerArray[n2];
            listener.actionPerformed(evt);
            ++n2;
        }
        but.getModel().setArmed(false);
        but.getModel().setPressed(false);
    }
}

