/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.app.joystick;

import de.hardcode.jxinput.Axis;
import de.hardcode.jxinput.Button;
import de.hardcode.jxinput.Directional;
import de.hardcode.jxinput.JXInputDevice;
import de.hardcode.jxinput.JXInputManager;

public class JoystickConfiguration {
    private static final String NAME_PEDAL = "Saitek Pro Flight Rudder Pedals";
    private static final String NAME_BLACK_WIDOW = "USB Game Controllers";
    private static final String NAME_LOGITECH_3D = "Logitech Extreme 3D";
    private static final String NAME_TRUSTMASTER = "Thrustmaster HOTAS Cougar";
    private JXInputDevice pedal = this.checkIfPedalAvailable();
    private JXInputDevice joystick;
    private boolean pedalAvailable = false;
    private boolean joystickLogitechAvailable = false;
    private boolean joystickBlackWidowAvailable = false;
    private boolean joystickTrustmasterAvailable = false;
    private boolean joystickOtherAvailable = false;
    private Button button1;
    private Button button2;
    private Button button3;
    private Button button4;
    private Button button5;
    private Button button_f2;
    private Button button_f3;
    private Button button_f4;
    private Directional hatSwitch;
    private Axis axisX;
    private Axis axisY;
    private Axis axisSlider;
    private Axis axisRotation;

    public JoystickConfiguration() {
        if (this.pedal != null) {
            this.pedalAvailable = true;
        }
        this.detectJoystick();
        if (this.joystick == null) {
            return;
        }
        this.setButtons();
        this.setXAxis();
        this.setYAxis();
        this.setSliderAxis();
        this.setRotationAxis();
        this.setHatSwitch();
    }

    private void setButtons() {
        this.button5 = this.joystick.getButton(0);
        if (this.joystickBlackWidowAvailable) {
            this.button1 = this.joystick.getButton(4);
            this.button2 = this.joystick.getButton(5);
            this.button3 = this.joystick.getButton(6);
            this.button4 = this.joystick.getButton(7);
            this.button_f2 = this.joystick.getButton(1);
            this.button_f3 = this.joystick.getButton(2);
            this.button_f4 = this.joystick.getButton(3);
            return;
        }
        if (this.joystickLogitechAvailable) {
            this.button1 = this.joystick.getButton(4);
            this.button2 = this.joystick.getButton(2);
            this.button3 = this.joystick.getButton(3);
            this.button4 = this.joystick.getButton(5);
            this.button_f2 = this.joystick.getButton(6);
            this.button_f3 = this.joystick.getButton(7);
            this.button_f4 = this.joystick.getButton(8);
            return;
        }
        if (this.joystickTrustmasterAvailable) {
            this.button1 = this.joystick.getButton(0);
            this.button2 = this.joystick.getButton(1);
            this.button3 = this.joystick.getButton(2);
            this.button4 = this.joystick.getButton(3);
            this.button5 = this.joystick.getButton(4);
            this.button_f2 = this.joystick.getButton(5);
            this.button_f3 = this.joystick.getButton(6);
            this.button_f4 = this.joystick.getButton(7);
            return;
        }
        if (this.joystickOtherAvailable) {
            this.button1 = this.joystick.getButton(0);
            this.button2 = this.joystick.getButton(1);
            this.button3 = this.joystick.getButton(2);
            this.button4 = this.joystick.getButton(3);
            this.button5 = this.joystick.getButton(4);
            this.button_f2 = this.joystick.getButton(5);
            this.button_f3 = this.joystick.getButton(6);
            this.button_f4 = this.joystick.getButton(7);
            return;
        }
    }

    private void setXAxis() {
        this.axisX = this.joystick.getAxis(0);
    }

    private void setYAxis() {
        this.axisY = this.joystick.getAxis(1);
    }

    private void setSliderAxis() {
        if (this.joystickBlackWidowAvailable) {
            this.axisSlider = this.joystick.getAxis(2);
            return;
        }
        if (this.joystickTrustmasterAvailable) {
            this.axisSlider = this.joystick.getAxis(2);
            return;
        }
        if (this.joystickLogitechAvailable) {
            this.axisSlider = this.joystick.getAxis(6);
            return;
        }
        if (this.joystickOtherAvailable) {
            int i = 0;
            while (i < this.joystick.getMaxNumberOfAxes()) {
                Axis axis = this.joystick.getAxis(i);
                if (axis != null && axis.getName().equals("ZAxis")) {
                    this.axisSlider = axis;
                    return;
                }
                ++i;
            }
        }
    }

    private void setRotationAxis() {
        if (this.pedalAvailable) {
            this.axisRotation = this.pedal.getAxis(5);
            return;
        }
        if (this.joystickLogitechAvailable) {
            this.axisRotation = this.joystick.getAxis(5);
            return;
        }
        if (this.joystickBlackWidowAvailable) {
            this.axisRotation = this.joystick.getAxis(5);
            return;
        }
        if (this.joystickTrustmasterAvailable) {
            this.axisRotation = this.joystick.getAxis(3);
            return;
        }
        if (this.joystickOtherAvailable) {
            int i = 0;
            while (i < this.joystick.getMaxNumberOfAxes()) {
                Axis axis = this.joystick.getAxis(i);
                if (axis != null && axis.getName().equals("ZRotation")) {
                    this.axisRotation = axis;
                    return;
                }
                ++i;
            }
        }
    }

    private void setHatSwitch() {
        this.hatSwitch = this.joystick.getDirectional(0);
    }

    private void detectJoystick() {
        this.joystick = this.checkIfLogitechJoystickAvailable();
        if (this.joystick != null) {
            this.joystickLogitechAvailable = true;
            return;
        }
        this.joystick = this.checkIfBlackWidowJoystickAvailable();
        if (this.joystick != null) {
            this.joystickBlackWidowAvailable = true;
            return;
        }
        this.joystick = this.checkIfThrustmasterJoystickAvailable();
        if (this.joystick != null) {
            this.joystickTrustmasterAvailable = true;
            return;
        }
        this.joystick = this.checkIfOtherJoystickAvailable();
        if (this.joystick != null) {
            this.joystickOtherAvailable = true;
            return;
        }
    }

    private JXInputDevice checkIfPedalAvailable() {
        int cnt = JXInputManager.getNumberOfDevices();
        if (cnt == 0) {
            return null;
        }
        int i = 0;
        while (i < cnt) {
            JXInputDevice device = JXInputManager.getJXInputDevice((int)i);
            if (device.getName().equals(NAME_PEDAL)) {
                return device;
            }
            ++i;
        }
        return null;
    }

    private JXInputDevice checkIfLogitechJoystickAvailable() {
        int cnt = JXInputManager.getNumberOfDevices();
        if (cnt == 0) {
            return null;
        }
        int i = 0;
        while (i < cnt) {
            JXInputDevice device = JXInputManager.getJXInputDevice((int)i);
            if (device.getName().equals(NAME_LOGITECH_3D)) {
                return device;
            }
            ++i;
        }
        return null;
    }

    private JXInputDevice checkIfBlackWidowJoystickAvailable() {
        int cnt = JXInputManager.getNumberOfDevices();
        if (cnt == 0) {
            return null;
        }
        int i = 0;
        while (i < cnt) {
            JXInputDevice device = JXInputManager.getJXInputDevice((int)i);
            if (device.getName().equals(NAME_BLACK_WIDOW)) {
                return device;
            }
            ++i;
        }
        return null;
    }

    private JXInputDevice checkIfThrustmasterJoystickAvailable() {
        int cnt = JXInputManager.getNumberOfDevices();
        if (cnt == 0) {
            return null;
        }
        int i = 0;
        while (i < cnt) {
            JXInputDevice device = JXInputManager.getJXInputDevice((int)i);
            if (device.getName().equals(NAME_TRUSTMASTER)) {
                return device;
            }
            ++i;
        }
        return null;
    }

    private JXInputDevice checkIfOtherJoystickAvailable() {
        int cnt = JXInputManager.getNumberOfDevices();
        if (cnt == 0) {
            return null;
        }
        int i = 0;
        while (i < cnt) {
            JXInputDevice device = JXInputManager.getJXInputDevice((int)i);
            if (!device.getName().equals(NAME_PEDAL)) {
                return device;
            }
            ++i;
        }
        return null;
    }

    protected boolean isFootpedalAvailable() {
        return this.pedalAvailable;
    }

    protected boolean isJoystickAvailable() {
        return this.joystick != null;
    }

    protected Button getButton1() {
        return this.button1;
    }

    protected Button getButton2() {
        return this.button2;
    }

    protected Button getButton3() {
        return this.button3;
    }

    protected Button getButton4() {
        return this.button4;
    }

    protected Button getButton5() {
        return this.button5;
    }

    protected Button getButtonF2() {
        return this.button_f2;
    }

    protected Button getButtonF3() {
        return this.button_f3;
    }

    protected Button getButtonF4() {
        return this.button_f4;
    }

    protected Directional getHatSwitch() {
        return this.hatSwitch;
    }

    protected Axis getAxisX() {
        return this.axisX;
    }

    protected Axis getAxisY() {
        return this.axisY;
    }

    protected Axis getAxisSlider() {
        return this.axisSlider;
    }

    protected Axis getAxisRotation() {
        return this.axisRotation;
    }

    public static void enumerateDevices() {
        int cnt = JXInputManager.getNumberOfDevices();
        System.out.println("Anzahl Devices: " + cnt);
        if (cnt == 0) {
            return;
        }
        int i = 0;
        while (i < cnt) {
            JXInputDevice device = JXInputManager.getJXInputDevice((int)i);
            System.out.println("Device with ID = " + i + ": " + device.getName());
            int numberAxis = device.getNumberOfAxes();
            System.out.println("- Device has " + numberAxis + " axes.");
            int j = 0;
            while (j < device.getMaxNumberOfAxes()) {
                Axis iAxis = device.getAxis(j);
                if (iAxis == null) {
                    System.out.println("   **  Axis null " + j);
                } else {
                    String typeString;
                    switch (iAxis.getType()) {
                        case 0: {
                            typeString = "Translation";
                            break;
                        }
                        case 1: {
                            typeString = "Rotation";
                            break;
                        }
                        case 2: {
                            typeString = "Slider";
                            break;
                        }
                        default: {
                            typeString = "Unknown";
                        }
                    }
                    System.out.println("   **  Axis resolution of axis " + j + ", type=" + typeString + ", is : " + iAxis.getResolution() + ", name=" + iAxis.getName());
                }
                ++j;
            }
            int buttonCnt = device.getNumberOfButtons();
            System.out.println("- Device has " + buttonCnt + " buttons.");
            int j2 = 0;
            while (j2 < buttonCnt) {
                Button button = device.getButton(j2);
                if (button == null) {
                    System.out.println("   **  Button null " + j2);
                } else {
                    System.out.println("   **  Button " + j2 + " typ:" + button.getType());
                }
                ++j2;
            }
            int dirCount = device.getMaxNumberOfDirectionals();
            System.out.println("- Device has " + dirCount + " directionals.");
            int j3 = 0;
            while (j3 < device.getMaxNumberOfDirectionals()) {
                Directional dir = device.getDirectional(j3);
                if (dir == null) {
                    System.out.println("   **  Directional null " + j3);
                } else {
                    System.out.println("   **  Directional " + j3 + " name:" + dir.getName());
                }
                ++j3;
            }
            ++i;
        }
    }
}

