/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.memorization.data;

import hsr.pma.util.Time;
import java.io.Serializable;
import org.jdom.Attribute;
import org.jdom.Element;

public class ResultAnswer
implements Serializable {
    private static final long serialVersionUID = -7450783590367706891L;
    private static final String RUNTIMEEXCEPTION_RESULT = "Fehler beim Einlesen der Resultate";
    private static final String XMLATTRIBUTE_ISCORRECT = "isCorrect";
    private static final String XMLELEMENT_ANSWER = "Answer";
    private static final String XMLELEMENT_CORRECTANSWER = "CorrectAnswer";
    private static final String XMLELEMENT_GIVENANSWER = "GivenAnswer";
    private static final String XMLELEMENT_REACTIONTIME = "ReactionTime";
    private static final String XMLELEMENT_STARTTIME = "StartTime";
    private static final String XMLATTRIBUTE_STARTTIME = "time";
    private boolean isCorrect;
    private Time startTime;
    private long reactionTime;
    private char correctAnswer;
    private char givenAnswer;

    public ResultAnswer(boolean isCorrect, Time startTime, long reactionTime, char correctAnswer, char givenAnswer) {
        this.isCorrect = isCorrect;
        this.startTime = startTime;
        this.reactionTime = reactionTime;
        this.correctAnswer = correctAnswer;
        this.givenAnswer = givenAnswer;
    }

    public Element toXML() {
        Element answer = new Element(XMLELEMENT_ANSWER);
        answer.setAttribute(XMLATTRIBUTE_STARTTIME, this.startTime.toString());
        answer.setAttribute(new Attribute(XMLATTRIBUTE_ISCORRECT, Boolean.toString(this.isCorrect)));
        Element timeElement = new Element(XMLELEMENT_REACTIONTIME);
        timeElement.setText(Long.toString(this.reactionTime));
        answer.addContent(timeElement);
        Element correctElement = new Element(XMLELEMENT_CORRECTANSWER);
        correctElement.setText(Character.toString(this.correctAnswer));
        answer.addContent(correctElement);
        Element givenElement = new Element(XMLELEMENT_GIVENANSWER);
        givenElement.setText(Character.toString(this.givenAnswer));
        answer.addContent(givenElement);
        return answer;
    }

    public static ResultAnswer fromXML(Element element) throws RuntimeException {
        try {
            String time;
            Time startTime = null;
            Element etime = element.getChild(XMLELEMENT_STARTTIME);
            if (etime != null) {
                time = etime.getText();
                String millis = etime.getAttributeValue("millis");
                String x = String.valueOf(time) + "." + millis;
                startTime = new Time(x);
            }
            if ((time = element.getAttributeValue(XMLATTRIBUTE_STARTTIME)) != null && time.length() > 0) {
                startTime = new Time(time);
            }
            boolean isCorrect = Boolean.parseBoolean(element.getAttributeValue(XMLATTRIBUTE_ISCORRECT));
            long reactionTime = Long.parseLong(element.getChildText(XMLELEMENT_REACTIONTIME));
            char correctAnswer = element.getChildText(XMLELEMENT_CORRECTANSWER).charAt(0);
            char givenAnswer = element.getChildText(XMLELEMENT_GIVENANSWER).charAt(0);
            return new ResultAnswer(isCorrect, startTime, reactionTime, correctAnswer, givenAnswer);
        }
        catch (Exception ex) {
            throw new RuntimeException(RUNTIMEEXCEPTION_RESULT);
        }
    }

    public char getCorrectAnswer() {
        return this.correctAnswer;
    }

    public char getGivenAnswer() {
        return this.givenAnswer;
    }

    public boolean isCorrect() {
        return this.isCorrect;
    }

    public long getReactionTime() {
        return this.reactionTime;
    }

    public Time getStarted() {
        return this.startTime;
    }
}

