/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.memorization.model.xml;

import hsr.pma.Language;
import hsr.pma.memorization.view.MemorizationLayouter;
import java.io.Serializable;
import java.util.Hashtable;
import org.jdom.Element;

public class Text
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String UNDEFINED = "UNDEFINED";
    protected Hashtable<Language, String> texts = new Hashtable();
    protected int fontSize = 100;
    private Language lang = Language.GERMAN;

    public Text() {
        Language[] languageArray = Language.values();
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language lang = languageArray[n2];
            this.texts.put(lang, UNDEFINED);
            ++n2;
        }
    }

    public Text(Element el) {
        this.fontSize = MemorizationLayouter.getFontSize(el.getName());
        String x = el.getAttributeValue("fontSize");
        if (x != null) {
            this.fontSize = Integer.parseInt(x);
        }
        Language[] languageArray = Language.values();
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language lang = languageArray[n2];
            x = el.getChildText(lang.abbreviation);
            if (x != null) {
                this.texts.put(lang, x);
            } else {
                this.texts.put(lang, UNDEFINED);
            }
            ++n2;
        }
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public String getText() {
        return this.texts.get((Object)this.lang);
    }

    public void setLanguage(Language lang) {
        this.lang = lang;
    }

    public Element toXml(String elementName) {
        Element el = new Element(elementName);
        int defaultFontSize = MemorizationLayouter.getFontSize(el.getName());
        if (this.fontSize != defaultFontSize) {
            el.setAttribute("fontSize", "" + this.fontSize);
        }
        this.appendTextElement(el, Language.GERMAN);
        this.appendTextElement(el, Language.FRENCH);
        this.appendTextElement(el, Language.ITALIAN);
        this.appendTextElement(el, Language.ENGLISH);
        return el;
    }

    private void appendTextElement(Element el, Language language) {
        if (this.texts.get((Object)language).equals(UNDEFINED)) {
            return;
        }
        Element x = new Element(language.abbreviation);
        x.setText(this.texts.get((Object)language));
        el.addContent(x);
    }
}

