/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.memorization.view;

import hsr.pma.memorization.model.ExampleQuestionSlide;
import hsr.pma.memorization.model.QuestionSlideListener;
import hsr.pma.memorization.view.QuestionSlidePanel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JLabel;

public class ExampleQuestionSlidePanel
extends QuestionSlidePanel
implements QuestionSlideListener {
    private static final long serialVersionUID = 1L;
    private JLabel okLabel = new JLabel();
    private JLabel failLabel;
    private boolean showFeedback = false;
    private String givenAnswer = "";
    private String correctAnswer = "";

    public ExampleQuestionSlidePanel(ExampleQuestionSlide slide) {
        super(slide);
        this.okLabel.setVisible(false);
        this.add(this.okLabel);
        this.failLabel = new JLabel();
        this.failLabel.setVisible(false);
        this.add(this.failLabel);
    }

    @Override
    protected void myLayout() {
        super.myLayout();
    }

    @Override
    public void showFeedback(String givenAnswer, String correctAnswer, boolean correct) {
        this.showFeedback = true;
        this.givenAnswer = givenAnswer;
        this.correctAnswer = correctAnswer;
        this.disableButtons();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.showFeedback) {
            JButton chosenBut = null;
            Component correctBut = null;
            for (JButton but : this.buttons) {
                if (but.getText().equals(this.givenAnswer)) {
                    chosenBut = but;
                }
                if (!but.getText().equals(this.correctAnswer)) continue;
                correctBut = but;
            }
            Rectangle rect = correctBut.getBounds();
            BufferedImage img = this.layouter.getGraphicsContext().getFeedbackOkImage();
            int xGap = (this.layouter.getGraphicsContext().getButtonSize() - img.getWidth()) / 2;
            int yOffset = img.getHeight() + xGap;
            g.drawImage(img, rect.x + xGap, rect.y - yOffset, null);
            if (!this.givenAnswer.equals(this.correctAnswer)) {
                rect = chosenBut.getBounds();
                img = this.layouter.getGraphicsContext().getFeedbackFailImage();
                g.drawImage(img, rect.x + xGap, rect.y - yOffset, null);
            }
        }
    }
}

