/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.memorization.view;

import hsr.pma.app.view.components.AButton;
import hsr.pma.app.view.components.ALabel;
import hsr.pma.app.view.components.ATextArea;
import hsr.pma.app.view.components.NextButton;
import hsr.pma.app.view.graphics.ApplicationLayouter;
import hsr.pma.memorization.model.QuestionSlide;
import hsr.pma.memorization.model.QuestionSlideListener;
import hsr.pma.memorization.model.xml.SimpleText;
import hsr.pma.memorization.view.SlidePanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class QuestionSlidePanel
extends SlidePanel
implements QuestionSlideListener {
    private static final long serialVersionUID = 1L;
    private final QuestionSlide slide;
    private JLabel title;
    private JTextArea text;
    protected List<JButton> buttons = new ArrayList<JButton>();
    protected List<JLabel> labels = new ArrayList<JLabel>();
    protected JButton nextButton;

    public QuestionSlidePanel(final QuestionSlide slide) {
        this.slide = slide;
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.title = new ALabel(slide.getTitle().getText());
        this.title.setForeground(ApplicationLayouter.COLOR_TITLE);
        this.text = new ATextArea(slide.getText().getText());
        this.setLayout(null);
        for (SimpleText but : slide.getButtons()) {
            final AButton jbut = new AButton(but.getText());
            jbut.setMargin(new Insets(0, 0, 0, 0));
            jbut.setFocusable(false);
            jbut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    QuestionSlidePanel.this.answerButtonPressed(jbut);
                }
            });
            this.buttons.add(jbut);
            this.add(jbut);
        }
        for (SimpleText jlab : slide.getJoystickLabels()) {
            JLabel jl = new JLabel(jlab.getText());
            this.labels.add(jl);
            this.add(jl);
        }
        this.nextButton = new NextButton();
        this.nextButton.setVisible(false);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                slide.handleNextButtonPressed();
            }
        });
        this.addButtonShortcuts();
        this.add(this.title);
        this.add(this.text);
        this.add(this.nextButton);
        slide.setQuestionSlideListener(this);
    }

    private void addButtonShortcuts() {
        int i = 0;
        while (i < this.buttons.size()) {
            final JButton button = this.buttons.get(i);
            String cmd = "F" + (5 + i) + "_PRESSED";
            button.getInputMap(2).put(KeyStroke.getKeyStroke(116 + i, 0), cmd);
            button.getActionMap().put(cmd, new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    QuestionSlidePanel.this.answerButtonPressed(button);
                }
            });
            ++i;
        }
        this.nextButton.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "next");
        this.nextButton.getActionMap().put("next", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                QuestionSlidePanel.this.slide.handleNextButtonPressed();
            }
        });
    }

    private void answerButtonPressed(JButton but) {
        this.disableButtons();
        but.setBackground(ApplicationLayouter.COLOR_TITLE);
        this.slide.handleAnswerButtonPressed(but.getText());
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width >= 100 && height >= 100) {
            this.myLayout();
        }
    }

    protected void disableButtons() {
        for (JButton jbut : this.buttons) {
            jbut.setEnabled(false);
        }
    }

    @Override
    public void joystickButtonPressed(int joystickButton) {
        switch (joystickButton) {
            case 4: {
                if (!this.nextButton.isVisible()) break;
                this.dispatchActionEvent(this.nextButton);
                break;
            }
            case 0: {
                JButton but = this.buttons.get(0);
                if (!but.isEnabled()) break;
                this.dispatchActionEvent(but);
                break;
            }
            case 1: {
                JButton but = this.buttons.get(1);
                if (!but.isEnabled()) break;
                this.dispatchActionEvent(but);
                break;
            }
            case 2: {
                JButton but = this.buttons.get(2);
                if (!but.isEnabled()) break;
                this.dispatchActionEvent(but);
                break;
            }
            case 3: {
                JButton but = this.buttons.get(3);
                if (!but.isEnabled()) break;
                this.dispatchActionEvent(but);
            }
        }
    }

    protected void myLayout() {
        this.layouter.layoutTitleText(this.title, this.text, this.slide.getTitle().getFontSize(), this.slide.getText().getFontSize());
        ArrayList<Integer> fontSizes = new ArrayList<Integer>();
        for (SimpleText st : this.slide.getButtons()) {
            fontSizes.add(st.getFontSize());
        }
        this.layouter.layoutButtons(this.buttons, fontSizes);
        fontSizes = new ArrayList();
        for (SimpleText st : this.slide.getJoystickLabels()) {
            fontSizes.add(st.getFontSize());
        }
        this.layouter.layoutButtonLabels(this.labels, fontSizes);
        this.layouter.layoutNextButton(this.nextButton);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(g);
        this.requestFocusInWindow();
    }

    @Override
    public void showFeedback(String givenAnswer, String correctAnswer, boolean correct) {
    }

    @Override
    public void showNextButton() {
        this.nextButton.setVisible(true);
    }
}

