/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.memorization.view;

import hsr.pma.app.view.graphics.ApplicationLayouter;
import hsr.pma.memorization.model.SequenceSlide;
import hsr.pma.memorization.model.TimerTickListener;
import hsr.pma.memorization.view.SlidePanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public class SequenceSlidePanel
extends SlidePanel
implements TimerTickListener {
    private static final long serialVersionUID = 1L;
    private final SequenceSlide slide;
    private JLabel title;
    private JTextArea text;
    private JLabel sequence;
    private JLabel timerText;

    public SequenceSlidePanel(SequenceSlide slide) {
        this.slide = slide;
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.title = new JLabel(slide.getTitle().getText());
        this.title.setForeground(ApplicationLayouter.COLOR_TITLE);
        this.text = new JTextArea(slide.getText().getText());
        this.text.setWrapStyleWord(true);
        this.text.setLineWrap(true);
        this.text.setEditable(false);
        this.sequence = new JLabel(slide.getSequence().getText());
        this.setLayout(null);
        this.add(this.title);
        this.add(this.text);
        this.add(this.sequence);
        this.timerText = new JLabel(slide.getTimerText().getTimerText());
        this.timerText.setVisible(slide.displayTimer());
        slide.getTimerText().setListener(this);
        this.add(this.timerText);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width >= 100 && height >= 100) {
            this.myLayout();
        }
    }

    private void myLayout() {
        this.layouter.layoutTitleText(this.title, this.text, this.slide.getTitle().getFontSize(), this.slide.getText().getFontSize());
        this.layouter.layoutTextCenteredBold(this.sequence, this.slide.getSequence().getFontSize());
        this.layouter.layoutTextSouthCentered(this.timerText, this.slide.getTimerText().getFontSize());
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(g);
    }

    @Override
    public void refreshTimerText(String text) {
        this.timerText.setText(text);
    }
}

