/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.standalone.io;

import hsr.pma.standalone.io.CryptInputStream;
import hsr.pma.standalone.model.Standalone;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class StandaloneIO {
    public static final String FILENAME = "standalone.xml";
    public static final String POSTFIX_CRYPTED = ".cry";
    public static String BASE_DIR = "";

    public Standalone readFromFile(String filename) throws Exception {
        String filePath = String.valueOf(BASE_DIR) + filename;
        File file = new File(filePath);
        if (file.exists()) {
            return this.read(file);
        }
        String cfilePath = filePath.replace(".xml", POSTFIX_CRYPTED);
        file = new File(cfilePath);
        if (file.exists()) {
            return this.read(file);
        }
        throw new RuntimeException("File not found: " + filename);
    }

    public Standalone read(File file) throws Exception {
        Standalone standalone;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            if (!file.getName().endsWith(POSTFIX_CRYPTED)) {
                Standalone standalone2 = this.read(in);
                return standalone2;
            }
            CryptInputStream cin = new CryptInputStream(in);
            standalone = this.read(cin);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return standalone;
    }

    public Standalone readFromJar() throws Exception {
        block15: {
            Standalone standalone;
            InputStream in = null;
            try {
                in = ClassLoader.getSystemClassLoader().getResourceAsStream(FILENAME.replace(".xml", POSTFIX_CRYPTED));
                if (in != null) {
                    CryptInputStream cin = new CryptInputStream(in);
                    Standalone standalone2 = this.read(cin);
                    return standalone2;
                }
                in = ClassLoader.getSystemClassLoader().getResourceAsStream(FILENAME);
                if (in == null) break block15;
                standalone = this.read(in);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            return standalone;
        }
        return null;
    }

    public Standalone read(InputStream in) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(in);
        Element root = doc.getRootElement();
        Standalone stand = new Standalone(root);
        doc.removeContent();
        return stand;
    }

    public void write(Standalone stand, File file) throws Exception {
        OutputStream out = null;
        try {
            try {
                out = new FileOutputStream(file);
                this.write(stand, out);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public void write(Standalone stand, OutputStream out) throws Exception {
        Format format = Format.getPrettyFormat();
        format.setEncoding("ISO-8859-1");
        format.setTextMode(Format.TextMode.PRESERVE);
        XMLOutputter outputter = new XMLOutputter(format);
        Document doc = new Document();
        doc.setRootElement(stand.toXml());
        outputter.output(doc, out);
    }
}

