/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.standalone.pd;

import hsr.pma.app.IResultStep;
import hsr.pma.app.ITestApplication;
import hsr.pma.app.view.ObserverArg;
import hsr.pma.standalone.io.ApplicationIO;
import hsr.pma.standalone.io.StandaloneIO;
import hsr.pma.standalone.model.Screen;
import hsr.pma.standalone.model.Standalone;
import hsr.pma.standalone.pd.ControllerListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;

public class Controller
implements Observer {
    private static final boolean DEBUG = false;
    private Standalone model;
    private ITestApplication application;
    private List<ControllerListener> listeners = new ArrayList<ControllerListener>();
    private JPanel applicationPanel;
    private boolean panelAssigned = false;
    private boolean withinJar = false;

    public Controller() {
        String x = Controller.class.getResource("Controller.class").toString();
        if (x.startsWith("jar")) {
            this.withinJar = true;
        }
    }

    public void loadModel() throws Exception {
        this.model = this.withinJar ? new StandaloneIO().readFromJar() : new StandaloneIO().readFromFile("standalone.xml");
    }

    public void loadApplication() throws Exception {
        this.application = this.withinJar ? new ApplicationIO().readFromJar() : new ApplicationIO().readFromFile("config.xml");
        this.application.setStandalone(true);
        this.application.setLanguage(this.model.getLanguage());
        this.application.addObserver(this);
        this.application.init();
    }

    public void setApplicationPanel(JPanel panel) {
        this.applicationPanel = panel;
    }

    public void startInstruction() {
        this.fireListener(this.model.getContentScreen());
        if (!this.panelAssigned) {
            this.application.setPanel(this.applicationPanel);
            this.panelAssigned = true;
        }
        this.application.startInstruction();
    }

    public void startTest() {
        this.model.getResultScreen().clear();
        this.fireListener(this.model.getContentScreen());
        if (!this.panelAssigned) {
            this.application.setPanel(this.applicationPanel);
            this.panelAssigned = true;
        }
        this.application.startTest();
    }

    public void startTest(int index) {
        this.model.getResultScreen().clear();
        this.fireListener(this.model.getContentScreen());
        if (!this.panelAssigned) {
            this.application.setPanel(this.applicationPanel);
            this.panelAssigned = true;
        }
        this.application.startTest(index);
    }

    public Standalone getModel() {
        return this.model;
    }

    public String getTitle() {
        return this.model.getStartScreen().getTitle().getText();
    }

    public void showStart() {
        if (!this.model.getStartScreen().isVisible()) {
            this.showLicense();
            return;
        }
        this.fireListener(this.model.getStartScreen());
    }

    public void showLicense() {
        if (!this.model.getLicenseScreen().isVisible()) {
            this.showControl();
            return;
        }
        this.fireListener(this.model.getLicenseScreen());
    }

    public void showControl() {
        this.fireListener(this.model.getControlScreen());
    }

    public void showResult() {
        if (!this.model.getResultScreen().isVisible()) {
            this.showControl();
            return;
        }
        this.model.getResultScreen().evaluate();
        this.fireListener(this.model.getResultScreen());
    }

    public void showEnd() {
        this.application.dispose();
        if (!this.model.getEndScreen().isVisible()) {
            System.exit(0);
        }
        this.fireListener(this.model.getEndScreen());
        this.model.getEndScreen().shutdown();
    }

    public void addListener(ControllerListener listener) {
        this.listeners.add(listener);
    }

    private void fireListener(Screen screen) {
        for (ControllerListener cl : this.listeners) {
            cl.showScreen(screen);
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (!(arg1 instanceof ObserverArg)) {
            return;
        }
        ObserverArg oa = (ObserverArg)arg1;
        if (oa.cmd == 1) {
            switch (this.application.getState()) {
                case PAUSE: {
                    this.showControl();
                    break;
                }
                case ENDED: {
                    this.showResult();
                    break;
                }
            }
        } else if (oa.cmd == 2) {
            this.model.getResultScreen().addStep((IResultStep)oa.obj);
        }
    }
}

