/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.standalone.model;

import hsr.pma.Language;
import hsr.pma.app.IResultStep;
import hsr.pma.standalone.model.Screen;
import hsr.pma.standalone.model.Standalone;
import hsr.pma.standalone.model.Text;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ResultScreen
extends Screen {
    private static boolean DEBUG = false;
    private Text title = new Text();
    private Text text = new Text();
    private List<IResultStep> steps = new ArrayList<IResultStep>();
    private int answerCount = 0;
    private int correctCount = 0;

    public ResultScreen(Standalone stand) {
        super(stand);
    }

    public ResultScreen(Element el, Standalone stand) {
        this(stand);
        this.parseVisible(el);
        this.title = new Text(el.getChild("Title"));
        this.text = new Text(el.getChild("Text"));
    }

    public Text getTitle() {
        return this.title;
    }

    public Text getText() {
        return this.text;
    }

    @Override
    public void setLanguage(Language lang) {
        this.title.setLanguage(lang);
        this.text.setLanguage(lang);
    }

    public String getResult() {
        String x = this.getText().getText();
        x = x.replace("{0}", "" + this.answerCount);
        x = x.replace("{1}", "" + this.correctCount);
        return x;
    }

    public int getResultPercent() {
        if (this.answerCount == 0) {
            return 0;
        }
        return (int)Math.round((double)this.correctCount / (double)this.answerCount * 100.0);
    }

    public void clear() {
        this.steps.clear();
    }

    public void addStep(IResultStep step) {
        this.steps.add(step);
        if (DEBUG) {
            this.debugStep(step);
        }
    }

    public void evaluate() {
        if (this.steps.size() == 0) {
            return;
        }
        this.correctCount = 0;
        this.answerCount = 0;
        ArrayList<Element> elements = new ArrayList<Element>();
        for (IResultStep rs : this.steps) {
            elements.add(rs.toXML());
        }
        try {
            switch (this.getRestultStepType(this.steps.get(0))) {
                case INF_ORD: {
                    this.evaluateInfOrd(elements);
                    break;
                }
                case MEM: {
                    this.evaluateMem(elements);
                    break;
                }
                case SEL_ATT: {
                    this.evaluateSelAtt(elements);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ResultStepType getRestultStepType(IResultStep step) {
        String name = step.getClassName();
        if (name.equals("hsr.pma.testapp.informationordering.pd.InformationOrderingResultStep")) {
            return ResultStepType.INF_ORD;
        }
        if (name.equals("hsr.pma.memorization.data.MemorizationApplicationResultStep")) {
            return ResultStepType.MEM;
        }
        if (name.equals("hsr.pma.testapp.selectiveAttention.pd.Result")) {
            return ResultStepType.SEL_ATT;
        }
        if (name.equals("hsr.pma.testapp.questionary.pd.QuestionaryResultStep")) {
            return ResultStepType.INF_ORD;
        }
        if (name.equals("hsr.pma.testapp.missionefficiency.pd.MissionEfficiencyResultStep")) {
            System.err.println("[ResultScreen] Mission Efficiency is not supported");
        } else {
            if (name.equals("hsr.pma.testapp.web.vis.figure.pd.VisualizationFigureResultStep")) {
                return ResultStepType.INF_ORD;
            }
            if (name.equals("hsr.pma.testapp.web.spatialorientation.pd.SpatialOrientationResultStep")) {
                return ResultStepType.INF_ORD;
            }
            if (name.equals("hsr.pma.testapp.numberfacility.NumberFacilityResultStep")) {
                return ResultStepType.INF_ORD;
            }
            if (name.equals("hsr.pma.testapp.vis.paper.pd.VisualizationPaperResultStep")) {
                return ResultStepType.INF_ORD;
            }
        }
        System.err.println("[ResultScreen] unknown ResultStep: " + name);
        return ResultStepType.UNKNOWN;
    }

    private void evaluateInfOrd(List<Element> elements) {
        this.answerCount = elements.size();
        for (Element el : elements) {
            boolean correct = Boolean.parseBoolean(el.getAttributeValue("isCorrect"));
            if (!correct) continue;
            ++this.correctCount;
        }
    }

    private void evaluateMem(List<Element> elements) {
        for (Element el : elements) {
            for (Object answer : el.getChildren("Answer")) {
                boolean correct = Boolean.parseBoolean(((Element)answer).getAttributeValue("isCorrect"));
                if (correct) {
                    ++this.correctCount;
                }
                ++this.answerCount;
            }
        }
    }

    private void evaluateSelAtt(List<Element> elements) {
        for (Element el : elements) {
            for (Object answer : el.getChildren("Step")) {
                String type = ((Element)answer).getChildText("Type");
                if (type.equals("CorrectRejection") || type.equals("Hit")) {
                    ++this.correctCount;
                }
                ++this.answerCount;
            }
        }
    }

    private void debugStep(IResultStep step) {
        System.out.println(step.getClassName());
        Element el = step.toXML();
        Format format = Format.getPrettyFormat();
        format.setEncoding("ISO-8859-1");
        format.setTextMode(Format.TextMode.PRESERVE);
        XMLOutputter outputter = new XMLOutputter(format);
        Document doc = new Document();
        doc.setRootElement(el);
        try {
            outputter.output(doc, (OutputStream)System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Element toXml() {
        Element el = new Element("ResultScreen");
        this.appendVisible(el);
        el.addContent(this.title.toXml("Title"));
        el.addContent(this.text.toXml("Text"));
        return el;
    }

    private static enum ResultStepType {
        INF_ORD,
        MEM,
        SEL_ATT,
        UNKNOWN;

    }
}

