/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.informationordering.pd;

import hsr.pma.app.ITestApplication;
import hsr.pma.app.ResultStep;
import hsr.pma.app.view.ObserverArg;
import hsr.pma.testapp.informationordering.pd.Answer;
import hsr.pma.testapp.informationordering.pd.InfoSlide;
import hsr.pma.testapp.informationordering.pd.InformationOrdering;
import hsr.pma.testapp.informationordering.pd.InformationOrderingResultStep;
import hsr.pma.testapp.informationordering.pd.NextSleeper;
import hsr.pma.testapp.informationordering.pd.Symbol;
import hsr.pma.testapp.informationordering.pd.Type;
import hsr.pma.util.Clock;
import hsr.pma.util.Time;
import java.util.ArrayList;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionSlide
extends InfoSlide {
    private static final long serialVersionUID = 1L;
    public static String XML_NAME = "ActionSlide";
    private int difficulty = 1;
    private Type type = Type.kongruent;
    private Symbol symbol = Symbol.Stern;
    public int id = 0;
    ArrayList<Answer> answers = new ArrayList();
    private String firstAnswerSolution;
    private String secondAnswerSolution;
    private Time started;
    private long reactionTime;
    private State state = State.READY;
    public static final int OBS_STATE_CHANGED = 745;
    private String firstAnswer;
    private String secondAnswer;
    private boolean firstAnswerOk;
    private boolean secondAnswerOk;
    private boolean solvedQuasyCorrect = false;

    @Override
    public void setModel(InformationOrdering model) {
        this.model = model;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public Type getType() {
        return this.type;
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public ArrayList<Answer> getAnswers() {
        return this.answers;
    }

    public void handleAnswerButtonPressed(String answer) {
        switch (this.state) {
            case READY: {
                this.handleFirstButtonPressed(answer);
                break;
            }
            case FIRST_BUTTON_PRESSED: {
                this.handleSecondButtonPressed(answer);
                break;
            }
        }
    }

    private void handleFirstButtonPressed(String answer) {
        this.firstAnswer = answer;
        this.setState(State.FIRST_BUTTON_PRESSED);
    }

    private void handleSecondButtonPressed(String answer) {
        if (answer == this.firstAnswer) {
            return;
        }
        this.secondAnswer = answer;
        Time answerTime = Clock.getInstance().getTime();
        this.reactionTime = answerTime.getMillis() - this.started.getMillis();
        this.setState(State.SECOND_BUTTON_PRESSED);
        this.eval();
        ResultStep step = this.createResultStep(this.started);
        this.model.saveResultStep(step);
        if (!this.hasNextButton) {
            if (this.model.getState().equals((Object)ITestApplication.State.INSTRUCTING)) {
                double delay = this.model.getDelayFeedback();
                if (delay > 0.0) {
                    int delayms = (int)(delay * 1000.0);
                    NextSleeper sleeper = new NextSleeper(this.model, delayms);
                    sleeper.start();
                } else {
                    NextSleeper sleeper = new NextSleeper(this.model, 700);
                    sleeper.start();
                }
                return;
            }
            if (this.model.getState().equals((Object)ITestApplication.State.TESTING)) {
                double delay = this.model.getDelayTest();
                if (delay > 0.0) {
                    int delayms = (int)(delay * 1000.0);
                    NextSleeper sleeper = new NextSleeper(this.model, delayms);
                    sleeper.start();
                    return;
                }
                this.model.showNextSlide();
            }
        }
    }

    public boolean getOk() {
        return this.firstAnswerOk && this.secondAnswerOk;
    }

    public boolean getSolvedQuasyCorrect() {
        return this.solvedQuasyCorrect;
    }

    private void eval() {
        this.firstAnswerOk = this.firstAnswer.equals(this.firstAnswerSolution);
        this.secondAnswerOk = this.secondAnswer.equals(this.secondAnswerSolution);
        switch (this.symbol) {
            case Stern: {
                if (this.firstAnswer.equals(this.getFirstAnswerTriangle()) && this.secondAnswer.equals(this.getSecondAnswerTriangle())) {
                    this.solvedQuasyCorrect = true;
                    break;
                }
                this.solvedQuasyCorrect = false;
                break;
            }
            case Dreieck: {
                this.solvedQuasyCorrect = this.firstAnswer.equals(this.getFirstAnswerStar()) && this.secondAnswer.equals(this.getSecondAnswerStar());
            }
        }
    }

    private String getFirstAnswerStar() {
        return this.getMaxAnswer();
    }

    private String getSecondAnswerStar() {
        return this.getMinAnswer();
    }

    private String getFirstAnswerTriangle() {
        return this.getMinAnswer();
    }

    private String getSecondAnswerTriangle() {
        return this.getMaxAnswer();
    }

    private String getMaxAnswer() {
        int max = Integer.MIN_VALUE;
        for (Answer answer : this.answers) {
            int n = max = answer.number > max ? answer.number : max;
        }
        return "" + max;
    }

    private String getMinAnswer() {
        int min = Integer.MAX_VALUE;
        for (Answer answer : this.answers) {
            int n = min = answer.number < min ? answer.number : min;
        }
        return "" + min;
    }

    private Answer getSmallestAnswer() {
        int index = 0;
        int value = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.answers.size()) {
            Answer answer = this.answers.get(i);
            if (answer.number < value) {
                value = answer.number;
                index = i;
            }
            ++i;
        }
        return this.answers.get(index);
    }

    private Answer getHighestAnswer() {
        int index = 0;
        int value = Integer.MIN_VALUE;
        int i = 0;
        while (i < this.answers.size()) {
            Answer answer = this.answers.get(i);
            if (answer.number > value) {
                value = answer.number;
                index = i;
            }
            ++i;
        }
        return this.answers.get(index);
    }

    private void setState(State state) {
        this.state = state;
        this.setChanged();
        this.notifyObservers(new ObserverArg(745, (Object)state));
    }

    public State getState() {
        return this.state;
    }

    public static ActionSlide fromXML(Element el) {
        ActionSlide slide = new ActionSlide();
        InfoSlide.fromXML(el, slide);
        slide.difficulty = Integer.parseInt(el.getChildText("Difficulty"));
        slide.type = Type.fromXML(el.getChild("Type"));
        slide.symbol = Symbol.fromXML(el.getChild("Symbol"));
        String x = el.getAttributeValue("id");
        if (x != null) {
            slide.id = Integer.parseInt(x);
        }
        ArrayList<Answer> answers = new ArrayList<Answer>();
        for (Object obj : el.getChildren("Answer")) {
            answers.add(Answer.fromXML((Element)obj));
        }
        slide.answers = answers;
        Element solution = el.getChild("Solution");
        slide.firstAnswerSolution = solution.getAttributeValue("first");
        slide.secondAnswerSolution = solution.getAttributeValue("second");
        return slide;
    }

    @Override
    public Element toXML() {
        Element el = super.toXML();
        el.setName(XML_NAME);
        el.removeChild("Text");
        el.removeAttribute("nextButton");
        Element dif = new Element("Difficulty");
        dif.setText("" + this.difficulty);
        el.addContent(dif);
        if (this.id != 0) {
            el.setAttribute("id", "" + this.id);
        }
        el.addContent(this.type.toXML());
        el.addContent(this.symbol.toXML());
        for (Answer answer : this.answers) {
            el.addContent(answer.toXML());
        }
        Element solution = new Element("Solution");
        solution.setAttribute("first", this.firstAnswerSolution);
        solution.setAttribute("second", this.secondAnswerSolution);
        el.addContent(solution);
        return el;
    }

    public String getFirstAnswer() {
        return this.firstAnswer;
    }

    public String getSecondAnswer() {
        return this.secondAnswer;
    }

    public boolean isFirstAnswerOk() {
        return this.firstAnswerOk;
    }

    public boolean isSecondAnswerOk() {
        return this.secondAnswerOk;
    }

    public int getId() {
        return this.id;
    }

    public ResultStep createResultStep(Time started) {
        InformationOrderingResultStep step = new InformationOrderingResultStep();
        step.setStarted(started);
        step.setReactionTime(this.reactionTime);
        step.setIdSlide(this.id);
        step.setSmybol(this.symbol);
        step.setType(this.type);
        step.setSequence(this.answers);
        step.setAnswer1Correct(this.firstAnswerSolution);
        step.setAnswer2Correct(this.secondAnswerSolution);
        step.setSolvedCorrect(this.getOk());
        step.setSolvedQuasiCorrect(this.solvedQuasyCorrect);
        step.setUserAnswer1(this.getFirstAnswer());
        step.setUserAnswer2(this.getSecondAnswer());
        return step;
    }

    @Override
    public void start() {
        this.reset();
        super.start();
    }

    public void reset() {
        this.firstAnswer = "";
        this.secondAnswer = "";
        this.firstAnswerOk = false;
        this.secondAnswerOk = false;
        this.setState(State.READY);
    }

    public void setStarted() {
        this.started = Clock.getInstance().getTime();
    }

    public static /* bridge */ /* synthetic */ InfoSlide fromXML(Element element) {
        return ActionSlide.fromXML(element);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        READY,
        FIRST_BUTTON_PRESSED,
        SECOND_BUTTON_PRESSED;

    }
}

