/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.informationordering.view;

import hsr.pma.app.joystick.ButtonListener;
import hsr.pma.app.view.components.AButton;
import hsr.pma.app.view.components.ALabel;
import hsr.pma.app.view.components.ATextArea;
import hsr.pma.app.view.components.NextButton;
import hsr.pma.app.view.graphics.ApplicationLayouter;
import hsr.pma.testapp.informationordering.pd.Answer;
import hsr.pma.testapp.informationordering.pd.ExampleSlide;
import hsr.pma.testapp.informationordering.pd.InformationOrdering;
import hsr.pma.testapp.informationordering.view.InformationOrderingLayouter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class ExampleSlidePanel
extends JPanel
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private final InformationOrdering model;
    private ExampleSlide slide;
    private JTextArea area = new ATextArea();
    private JButton nextButton = new NextButton();
    private Polygon polygon;
    private ArrayList<JButton> answerButtons = new ArrayList();
    private ArrayList<JLabel> answerLabels = new ArrayList();
    private JLabel title = new ALabel();
    private InformationOrderingLayouter layouter;
    private JLabel firstNumber = new JLabel("1.");
    private JLabel secondNumber = new JLabel("2.");

    public ExampleSlidePanel(InformationOrdering model) {
        this.model = model;
        this.layouter = new InformationOrderingLayouter(this);
        this.setBackground(ApplicationLayouter.COLOR_BACKGROUND);
        this.setOpaque(true);
        this.setLayout(null);
        this.add(this.title);
        this.add(this.area);
        this.firstNumber.setForeground(ApplicationLayouter.COLOR_GREEN);
        this.add(this.firstNumber);
        this.secondNumber.setForeground(ApplicationLayouter.COLOR_GREEN);
        this.add(this.secondNumber);
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExampleSlidePanel.this.handleNextButtonPressed();
            }
        });
        this.add(this.nextButton);
        this.createAnswerButtons();
    }

    private void createAnswerButtons() {
        int i = 0;
        while (i < 4) {
            AButton button = new AButton();
            button.setMargin(new Insets(0, 0, 0, 0));
            button.setEnabled(false);
            this.add(button);
            this.answerButtons.add(button);
            ALabel label = new ALabel(this.model.getButtonLabels().get(i));
            label.setForeground(ApplicationLayouter.COLOR_TITLE);
            this.add(label);
            this.answerLabels.add(label);
            ++i;
        }
    }

    public void setSlide(ExampleSlide slide) {
        this.slide = slide;
        this.title.setText(slide.getTitle());
        this.area.setText(slide.getText());
        if (slide.hasNextButton()) {
            this.nextButton.setVisible(true);
        } else {
            this.nextButton.setVisible(false);
        }
        ArrayList<Answer> answers = slide.getAnswers();
        int i = 0;
        while (i < this.answerButtons.size()) {
            JButton button = this.answerButtons.get(i);
            button.setText("" + answers.get((int)i).number);
            ++i;
        }
        this.myLayout();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width < 10) {
            return;
        }
        if (height < 10) {
            return;
        }
        this.myLayout();
    }

    public void myLayout() {
        this.layouter.layoutTitleTextNextButton(this.title, this.area, this.nextButton);
        this.polygon = this.layouter.createPolygon(this.slide.getSymbol(), true);
        ArrayList<Answer> answers = this.slide.getAnswers();
        this.layouter.layoutAnswerButtons(this.answerButtons, answers, this.answerLabels);
        int index = this.getIndexAnswer(this.slide.getFirstAnswerSolution());
        this.layouter.layoutAnswerNumber(this.firstNumber, index);
        index = this.getIndexAnswer(this.slide.getSecondAnswerSolution());
        this.layouter.layoutAnswerNumber(this.secondNumber, index);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(g);
        Rectangle bounds = this.getBounds();
        if (bounds.width == 0) {
            return;
        }
        if (bounds.height == 0) {
            return;
        }
        this.layouter.paintPolygon(g, this.polygon);
    }

    private int getIndexAnswer(String text) {
        int i = 0;
        while (i < this.answerButtons.size()) {
            JButton but = this.answerButtons.get(i);
            if (but.getText().equals(text)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void handleNextButtonPressed() {
        this.slide.handleNextPressed();
    }

    public void handleButtonPressed(int joystickButton) {
        switch (joystickButton) {
            case 4: {
                if (!this.slide.hasNextButton() || !this.nextButton.isEnabled()) break;
                this.dispatchActionEvent(this.nextButton);
            }
        }
    }

    private void dispatchActionEvent(JButton but) {
        but.getModel().setArmed(true);
        but.getModel().setPressed(true);
        Dimension d = but.getSize();
        but.paintImmediately(0, 0, d.width, d.height);
        ActionEvent evt = new ActionEvent(but, 1001, but.getActionCommand());
        ActionListener[] actionListenerArray = but.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener listener = actionListenerArray[n2];
            listener.actionPerformed(evt);
            ++n2;
        }
        but.getModel().setArmed(false);
        but.getModel().setPressed(false);
    }
}

