/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.informationordering.view;

import hsr.pma.app.view.graphics.ApplicationLayouter;
import hsr.pma.testapp.informationordering.pd.Answer;
import hsr.pma.testapp.informationordering.pd.Symbol;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InformationOrderingLayouter
extends ApplicationLayouter {
    public static final double MAX_WIDTH_TEXT_BUTTON = 0.8;
    private static final int[] FONT_SIZE_BUTTONS = new int[]{63, 90, 127, 180};
    private int[] xPointsStar;
    private int[] yPointsStar;
    private int[] xPointsTriangle;
    private int[] yPointsTriangle;

    public InformationOrderingLayouter(JPanel panel) {
        super(panel);
        int[] nArray = new int[10];
        nArray[1] = -11;
        nArray[2] = -47;
        nArray[3] = -19;
        nArray[4] = -29;
        nArray[6] = 29;
        nArray[7] = 19;
        nArray[8] = 47;
        nArray[9] = 11;
        this.xPointsStar = nArray;
        this.yPointsStar = new int[]{-50, -16, -15, 6, 40, 20, 40, 6, -15, -16};
        int[] nArray2 = new int[3];
        nArray2[1] = 50;
        nArray2[2] = -50;
        this.xPointsTriangle = nArray2;
        this.yPointsTriangle = new int[]{-50, 30, 30};
    }

    private Point[] createPoints(Symbol symbol) {
        double factor = 45.55;
        double scale = (double)this.gc.getButtonSize() / 45.55;
        Point[] points = null;
        switch (symbol) {
            case Dreieck: {
                points = this.scalePolygon(this.xPointsTriangle, this.yPointsTriangle, scale);
                break;
            }
            case Stern: {
                points = this.scalePolygon(this.xPointsStar, this.yPointsStar, scale);
            }
        }
        if (points == null) {
            throw new RuntimeException("Unknown Symbol");
        }
        return points;
    }

    private Point[] createPointsSmall(Symbol symbol) {
        double factor = 65.0;
        double scale = (double)this.gc.getButtonSize() / 65.0;
        Point[] points = null;
        switch (symbol) {
            case Dreieck: {
                points = this.scalePolygon(this.xPointsTriangle, this.yPointsTriangle, scale);
                break;
            }
            case Stern: {
                points = this.scalePolygon(this.xPointsStar, this.yPointsStar, scale);
            }
        }
        if (points == null) {
            throw new RuntimeException("Unknown Symbol");
        }
        return points;
    }

    public Polygon createPolygon(Symbol symbol, boolean example) {
        Dimension d = this.gc.getSize();
        int xOffset = (int)(0.5 * (double)d.width);
        int yOffset = (int)(0.5 * (double)d.height) - (int)(0.5 * (double)this.gc.getButtonSize());
        Point[] points = this.createPoints(symbol);
        if (example) {
            yOffset = (int)(0.5 * (double)d.height);
            points = this.createPointsSmall(symbol);
        }
        this.movePolygon(points, xOffset, yOffset);
        Polygon polygon = new Polygon();
        int i = 0;
        while (i < points.length) {
            polygon.addPoint(points[i].x, points[i].y);
            ++i;
        }
        return polygon;
    }

    private Point[] scalePolygon(int[] xArray, int[] yArray, double scale) {
        Point[] points = new Point[xArray.length];
        int i = 0;
        while (i < xArray.length) {
            int x = (int)(scale * (double)xArray[i]);
            int y = (int)(scale * (double)yArray[i]);
            points[i] = new Point(x, y);
            ++i;
        }
        return points;
    }

    private void movePolygon(Point[] points, int xOffset, int yOffset) {
        Point[] pointArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Point point = pointArray[n2];
            point.x += xOffset;
            point.y += yOffset;
            ++n2;
        }
    }

    public void paintPolygon(Graphics g, Polygon polygon) {
        BasicStroke stroke = new BasicStroke((float)this.gc.getButtonSize() / 30.0f);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.GRAY);
        g2.fill(polygon);
        g2.setStroke(stroke);
        g2.setColor(Color.BLACK);
        g2.draw(polygon);
    }

    public void layoutAnswerNumber(JLabel label, int index) {
        label.setFont(this.gc.getFontBold(100));
        label.setForeground(COLOR_GREEN);
        int buttonSize = this.gc.getButtonSize();
        Dimension labelSize = label.getPreferredSize();
        int offsetX = (buttonSize - labelSize.width) / 2;
        int startX = this.getAnswerButtonXOffset() + index * (buttonSize + this.gc.getAnswerButtonXGap()) + offsetX;
        int startY = this.getAnswerButtonYOffset() - labelSize.height - this.gc.getAnswerButtonLabelYGap();
        label.setBounds(startX, startY, labelSize.width, labelSize.height);
    }

    private int getAnswerButtonYOffset() {
        int yOffset = this.gc.getSize().height - this.gc.getBorder().bottom - this.gc.getButtonSize() - (int)(this.gc.getGrid() * 0.2);
        return yOffset;
    }

    private int getAnswerButtonXOffset() {
        int xOffset = (this.gc.getSize().width - 4 * this.gc.getButtonSize() - 3 * this.gc.getAnswerButtonXGap()) / 2;
        return xOffset;
    }

    public void layoutAnswerButtons(ArrayList<JButton> buttons, ArrayList<Answer> answers, ArrayList<JLabel> labels) {
        int buttonSize = this.gc.getButtonSize();
        ArrayList<Integer> numberWidth = new ArrayList<Integer>();
        int i = 0;
        while (i < buttons.size()) {
            JButton but = buttons.get(i);
            int fontSize = FONT_SIZE_BUTTONS[answers.get((int)i).size - 1];
            Font f = this.gc.getFontBold(fontSize);
            FontMetrics fm = this.panel.getFontMetrics(f);
            int width = fm.stringWidth(but.getText());
            numberWidth.add(width);
            ++i;
        }
        double maxWidth = (double)buttonSize * 0.8;
        double scale = 1.0;
        Iterator width = numberWidth.iterator();
        while (width.hasNext()) {
            double scalex;
            int width2 = (Integer)width.next();
            if (!((double)width2 > maxWidth) || !((scalex = maxWidth / (double)width2) < scale)) continue;
            scale = scalex;
        }
        Font labelFont = this.gc.getFont(100);
        int i2 = 0;
        while (i2 < buttons.size()) {
            JButton but = buttons.get(i2);
            int fontSize = FONT_SIZE_BUTTONS[answers.get((int)i2).size - 1];
            fontSize = (int)((double)fontSize * scale);
            but.setFont(this.gc.getFontBold(fontSize));
            labels.get(i2).setFont(labelFont);
            ++i2;
        }
        int spacer = this.gc.getAnswerButtonXGap();
        int startX = this.getAnswerButtonXOffset();
        int startY = this.getAnswerButtonYOffset();
        int startLabelY = startY + buttonSize + this.gc.getAnswerButtonLabelYGap();
        int i3 = 0;
        while (i3 < 4) {
            JButton button = buttons.get(i3);
            button.setBounds(startX, startY, buttonSize, buttonSize);
            JLabel label = labels.get(i3);
            Dimension labelSize = label.getPreferredSize();
            int xOffs = (buttonSize - labelSize.width) / 2;
            label.setBounds(startX + xOffs, startLabelY, labelSize.width, labelSize.height);
            startX += buttonSize + spacer;
            ++i3;
        }
    }

    public void layoutFeedback(int index, boolean ok, Graphics g) {
        int buttonSize = this.gc.getButtonSize();
        int spacer = this.gc.getAnswerButtonXGap();
        int feedbackSize = this.gc.getFeedbackImageSize();
        int startX = this.getAnswerButtonXOffset() + index * (buttonSize + spacer) + (buttonSize - feedbackSize) / 2;
        int startY = this.getAnswerButtonYOffset() - feedbackSize;
        BufferedImage img = null;
        img = ok ? this.gc.getFeedbackOkImage() : this.gc.getFeedbackFailImage();
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage(img, null, startX, startY);
    }
}

