/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.app;

import hsr.pma.Language;
import hsr.pma.app.IResultStep;
import hsr.pma.app.ITestApplication;
import hsr.pma.app.Memo;
import hsr.pma.app.PMAEnvironment;
import hsr.pma.app.view.ObserverArg;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Observable;
import javax.swing.JPanel;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public abstract class DefaultTestApplication
extends Observable
implements ITestApplication,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String name = "";
    protected String abbreviation = "";
    protected String description = "";
    protected Language language = Language.GERMAN;
    protected boolean standalone = false;
    protected int pk = 0;
    protected Date inserted = new Date();
    protected boolean hidden = false;
    protected ITestApplication.State state = ITestApplication.State.READY;

    @Override
    public abstract String getApplicationName();

    @Override
    public abstract String getClassName();

    @Override
    public abstract String getClassNameResultStep();

    @Override
    public abstract void init();

    @Override
    public abstract void setPanel(JPanel var1);

    @Override
    public abstract void handleButtonPressed(int var1);

    @Override
    public abstract void startInstruction();

    @Override
    public abstract void stopInstruction();

    @Override
    public abstract void startTest();

    @Override
    public abstract void stopTest();

    @Override
    public abstract void abort();

    @Override
    public int getTestCount() {
        return 1;
    }

    @Override
    public void startTest(int index) {
        this.startTest();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setMemos(ArrayList<Memo> memos) {
    }

    @Override
    public abstract void setResultSteps(ArrayList<IResultStep> var1);

    @Override
    public abstract void startFailover();

    @Override
    public abstract void setConfiguration(Element var1);

    @Override
    public abstract Element getConfiguration();

    @Override
    public abstract Element toXML();

    public void fireException(Exception e) {
        this.setChanged();
        this.notifyObservers(new ObserverArg(3, e));
    }

    public void saveResultStep(IResultStep rs) {
        this.setChanged();
        this.notifyObservers(new ObserverArg(2, rs));
    }

    public void fireMemo(Memo memo) {
        this.setChanged();
        this.notifyObservers(new ObserverArg(4, memo));
    }

    public void setState(ITestApplication.State state) {
        this.state = state;
        this.setChanged();
        this.notifyObservers(new ObserverArg(1, (Object)state));
    }

    @Override
    public void toFile(File file) throws Exception {
        Document doc = new Document();
        doc.setRootElement(this.toXML());
        Format format = Format.getPrettyFormat();
        format.setEncoding("ISO-8859-1");
        XMLOutputter outputter = new XMLOutputter(format);
        FileWriter writer = new FileWriter(file);
        outputter.output(doc, (Writer)writer);
    }

    public static ITestApplication fromFile(File file) throws Exception {
        String path = file.getAbsolutePath();
        String fileName = file.getName();
        path = (String)path.subSequence(0, path.length() - fileName.length() - 1);
        PMAEnvironment.instance.setDocumentBase(path);
        PMAEnvironment.instance.setDocumentName(fileName);
        SAXBuilder builder = new SAXBuilder();
        FileInputStream instream = new FileInputStream(file);
        Document doc = builder.build(instream);
        Element root = doc.getRootElement();
        instream.close();
        return DefaultTestApplication.fromXMLs(root);
    }

    public static ITestApplication fromXMLs(Element element) {
        if (!element.getName().equals("TestApplication")) {
            throw new RuntimeException("[DefaultTestApplication:fromXMLs] wrong Element: TestApplication");
        }
        String className = element.getAttributeValue("class");
        ITestApplication ta = null;
        try {
            Class<?> c = Class.forName(className);
            Method m = c.getDeclaredMethod("fromXML", Element.class);
            ta = (ITestApplication)m.invoke(null, element);
            element.removeContent();
        }
        catch (InvocationTargetException e) {
            Throwable thrown = e.getTargetException();
            throw new RuntimeException(thrown.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        catch (Error e) {
            throw new RuntimeException(e);
        }
        return ta;
    }

    protected void setAttributesFromXML(Element el) {
        this.name = el.getChildText("Name");
        if (this.name == null) {
            throw new RuntimeException("Element <Name> fehlt.");
        }
        this.abbreviation = el.getChildText("Abbreviation");
        if (this.abbreviation == null) {
            throw new RuntimeException("Element <Abbreviation> fehlt.");
        }
        this.description = el.getChildText("Description");
        if (this.description == null) {
            throw new RuntimeException("Element <Description> fehlt.");
        }
    }

    protected void writeAttributesToXML(Element el) {
        el.setAttribute("class", this.getClassName());
        Element eName = new Element("Name");
        eName.setText(this.name);
        el.addContent(eName);
        Element eAbbrev = new Element("Abbreviation");
        eAbbrev.setText(this.abbreviation);
        el.addContent(eAbbrev);
        Element eDescr = new Element("Description");
        eDescr.setText(this.description);
        el.addContent(eDescr);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    @Override
    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isStandalone() {
        return this.standalone;
    }

    @Override
    public void setStandalone(boolean bool) {
        this.standalone = bool;
    }

    @Override
    public ITestApplication.State getState() {
        return this.state;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(Language language) {
        this.language = language;
    }

    @Override
    public int getPk() {
        return this.pk;
    }

    @Override
    public void setPk(int pk) {
        this.pk = pk;
    }

    public String toString() {
        return String.valueOf(this.name) + ": " + this.abbreviation;
    }

    @Override
    public Date getInserted() {
        return this.inserted;
    }

    public void setInserted(Date inserted) {
        this.inserted = inserted;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean hide) {
        this.hidden = hide;
    }

    @Override
    public int getDuration() {
        return -1;
    }
}

