/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.app.joystick;

import de.hardcode.jxinput.JXInputManager;
import hsr.pma.app.joystick.FrameListener;
import hsr.pma.app.joystick.Joystick;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;

public class FrameThread
extends Thread {
    private AtomicBoolean shutdown = new AtomicBoolean();
    private final int framerate = 100;
    private long start;
    private final long ticks;
    boolean debug = false;
    private Vector<FrameListener> listeners = new Vector();

    public FrameThread() {
        this.ticks = 10000000L;
        this.setName("PMA FrameThread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isShutdown()) {
            if (Joystick.getInstance().isEnabled()) {
                this.start = System.nanoTime();
                JXInputManager.updateFeatures();
                try {
                    this.fireFrame();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                long timeToSleep = (this.start + this.ticks - System.nanoTime()) / 1000000L;
                if (timeToSleep <= 0L) continue;
                try {
                    Thread.sleep(timeToSleep);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            FrameThread frameThread = this;
            synchronized (frameThread) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void shutdown() {
        this.shutdown.set(true);
    }

    private boolean isShutdown() {
        return this.shutdown.get();
    }

    public void addFrameListener(FrameListener listener) {
        this.listeners.add(listener);
    }

    public void removeFrameListener(FrameListener listener) {
        this.listeners.remove(listener);
    }

    private void fireFrame() {
        for (FrameListener listener : this.listeners) {
            listener.handleFrame();
        }
    }
}

