/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.app.joystick;

import de.hardcode.jxinput.Directional;
import hsr.pma.app.joystick.FrameListener;
import hsr.pma.app.joystick.HatSwitchListener;
import hsr.pma.app.joystick.Joystick;
import java.util.Vector;

class JoystickHatSwitch
implements FrameListener {
    private final Directional hatSwitch;
    Vector<HatSwitchListener> listeners = new Vector();

    public JoystickHatSwitch(Directional hatSwitch, Joystick joystick) {
        this.hatSwitch = hatSwitch;
        this.addHatSwitchListener(joystick);
    }

    @Override
    public void handleFrame() {
        double value = this.hatSwitch.getValue();
        if (value == 1.0) {
            int angle = this.hatSwitch.getDirection() / 100;
            this.fireHatSwitch(angle);
        }
    }

    protected void addHatSwitchListener(HatSwitchListener listener) {
        this.listeners.add(listener);
    }

    protected void removeHatSwitchListener(HatSwitchListener listener) {
        this.listeners.remove(listener);
    }

    private void fireHatSwitch(int angle) {
        for (HatSwitchListener listener : this.listeners) {
            listener.handleHatSwitch(angle);
        }
    }
}

