/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.app.view;

import hsr.pma.app.view.ImageFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTextArea;

public class StyleGuide {
    public static final String FONT_FAMILY = "Tahoma";
    public static final Color COLOR_BACKGROUND = Color.WHITE;
    public static final Color COLOR_TITLE = new Color(0, 78, 152);
    public static final Color COLOR_TEXT = Color.BLACK;
    public static final Color COLOR_RED = new Color(226, 11, 11);
    public static final Color COLOR_GREEN;
    public static final Color COLOR_BORDER_FOCUS;
    public static final Color COLOR_BORDER_NO_FOCUS;
    protected static final double BORDER_WIDTH = 0.112094;
    protected static final double BORDER_HEIGHT = 0.114286;
    protected int width = 0;
    protected int height = 0;
    protected int borderWidth;
    protected int borderHeight;
    protected Font fontTitle;
    protected Font fontText;
    protected Font fontButton;
    protected int fontButtonSize;
    protected int buttonSize;
    ImageFactory imageFactory = ImageFactory.getInstance();

    static {
        COLOR_BORDER_FOCUS = COLOR_GREEN = new Color(31, 133, 39);
        COLOR_BORDER_NO_FOCUS = Color.LIGHT_GRAY;
    }

    public void setSize(int width, int height) {
        if (width == 0) {
            throw new IllegalArgumentException("width 0");
        }
        if (height == 0) {
            throw new IllegalArgumentException("height 0");
        }
        this.width = width;
        this.height = height;
        this.calculateFontSizes();
        this.calcBorders();
        this.calcButtonSize();
    }

    public boolean isSizeDefined() {
        return this.height != 0;
    }

    public Font getFontTitle() {
        return this.fontTitle;
    }

    public Font getFontText() {
        return this.fontText;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public int getBorderHeight() {
        return this.borderHeight;
    }

    public int getButtonSize() {
        return this.buttonSize;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Font getFontButton() {
        return this.fontButton;
    }

    public int getFontButtonSize() {
        return this.fontButtonSize;
    }

    public void paint(Graphics g, String title, JTextArea area) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(COLOR_TITLE);
        g.setFont(this.fontTitle);
        g.drawString(title, this.borderWidth, this.borderHeight + this.fontTitle.getSize());
        int areaWidth = this.width - 2 * this.borderWidth;
        int areaHeight = this.height - 2 * this.borderHeight - 2 * this.fontTitle.getSize();
        area.setFont(this.fontText);
        area.setBounds(this.borderWidth, this.borderHeight + 2 * this.fontTitle.getSize(), areaWidth, areaHeight);
        area.setForeground(COLOR_TEXT);
        area.setBackground(COLOR_BACKGROUND);
    }

    public void paint(Graphics g, String title, JTextArea area, JButton button) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(COLOR_TITLE);
        g.setFont(this.fontTitle);
        g.drawString(title, this.borderWidth, this.borderHeight + this.fontTitle.getSize());
        int areaWidth = this.width - 2 * this.borderWidth;
        int areaHeight = this.height - 2 * this.borderHeight - 2 * this.fontTitle.getSize() - this.buttonSize - this.fontText.getSize();
        area.setFont(this.fontText);
        area.setBounds(this.borderWidth, this.borderHeight + 2 * this.fontTitle.getSize(), areaWidth, areaHeight);
        area.setForeground(COLOR_TEXT);
        area.setBackground(COLOR_BACKGROUND);
        int xButton = this.width - this.borderWidth - this.buttonSize;
        int yButton = this.height - this.borderHeight - this.buttonSize;
        button.setBounds(xButton, yButton, this.buttonSize, this.buttonSize);
        button.setIcon(this.getForwardIcon());
    }

    public Icon getForwardIcon() {
        if (this.buttonSize < 54) {
            return this.getIconForwardSmall();
        }
        if (this.buttonSize >= 54 && this.buttonSize < 78) {
            return this.getIconForwardMedium();
        }
        return this.getIconForwardLarge();
    }

    public Icon getOkIcon() {
        if (this.buttonSize < 54) {
            return this.getIconOkSmall();
        }
        if (this.buttonSize >= 54 && this.buttonSize < 78) {
            return this.getIconOkMedium();
        }
        return this.getIconOkLarge();
    }

    public Icon getFailIcon() {
        if (this.buttonSize < 54) {
            return this.getIconFailSmall();
        }
        if (this.buttonSize >= 54 && this.buttonSize < 78) {
            return this.getIconFailMedium();
        }
        return this.getIconFailLarge();
    }

    protected void calculateFontSizes() {
        double a = Math.sqrt(this.width * this.height) / 40.0;
        int textSize = (int)(a * 1.5);
        int titleSize = (int)(a * 2.0);
        this.fontText = new Font(FONT_FAMILY, 0, textSize);
        this.fontTitle = new Font(FONT_FAMILY, 1, titleSize);
        this.fontButtonSize = (int)(a * 3.0);
        this.fontButton = new Font(FONT_FAMILY, 1, this.fontButtonSize);
    }

    private void calcBorders() {
        this.borderWidth = (int)(0.112094 * (double)this.width);
        this.borderHeight = (int)(0.114286 * (double)this.height);
    }

    private void calcButtonSize() {
        double a = Math.sqrt(this.width * this.height) / 10.0;
        this.buttonSize = (int)a;
    }

    public Icon getIconFailLarge() {
        return this.imageFactory.getImage("fail-button-large.gif");
    }

    public Icon getIconFailMedium() {
        return this.imageFactory.getImage("fail-button-medium.gif");
    }

    public Icon getIconFailSmall() {
        return this.imageFactory.getImage("fail-button-small.gif");
    }

    public Icon getIconForwardLarge() {
        return this.imageFactory.getImage("forward-button-large.gif");
    }

    public Icon getIconForwardMedium() {
        return this.imageFactory.getImage("forward-button-medium.gif");
    }

    public Icon getIconForwardSmall() {
        return this.imageFactory.getImage("forward-button-small.gif");
    }

    public Icon getIconOkLarge() {
        return this.imageFactory.getImage("ok-button-large.gif");
    }

    public Icon getIconOkMedium() {
        return this.imageFactory.getImage("ok-button-medium.gif");
    }

    public Icon getIconOkSmall() {
        return this.imageFactory.getImage("ok-button-small.gif");
    }
}

