/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.app.view.feedback;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class FeedbackImage {
    private static final Object INTERPOLATION = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
    public static boolean DEBUG = false;
    private HashMap<Integer, BufferedImage> map = new HashMap();
    private BufferedImage lastImage = null;

    public FeedbackImage(URL url) {
        try {
            this.lastImage = ImageIO.read(url);
            this.map.put(this.lastImage.getWidth(), this.lastImage);
            int width = this.lastImage.getWidth() / 2;
            BufferedImage img = this.lastImage;
            while (width > 10) {
                img = this.scale(img, width);
                this.map.put(width, img);
                if (DEBUG) {
                    System.out.println("[FeedbackImage] put image size=" + width);
                }
                width /= 2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BufferedImage getImage(int size) {
        if (size == 0) {
            if (DEBUG) {
                System.out.println("[FeedbackImage:getImage] size is 0");
            }
            return new BufferedImage(1, 1, 2);
        }
        if (this.lastImage.getWidth() == size) {
            if (DEBUG) {
                System.out.println("[FeedbackImage:getImage] same as last image " + size);
            }
            return this.lastImage;
        }
        BufferedImage img = this.map.get(size);
        if (img != null) {
            if (DEBUG) {
                System.out.println("[FeedbackImage:getImage] image was cached " + size);
            }
            return img;
        }
        int nextLarger = this.getNextLargerSize(size);
        if (nextLarger == -1) {
            if (DEBUG) {
                System.out.println("[FeedbakImage:getImage] must scale up image " + size);
            }
            return this.scale(this.map.get(this.getLargestSize()), size);
        }
        img = this.map.get(nextLarger);
        this.lastImage = this.scale(img, size);
        return this.lastImage;
    }

    private BufferedImage scale(BufferedImage orig, int size) {
        if (DEBUG) {
            System.out.println("[FeedbackImage:scale] scale " + orig.getWidth() + " to " + size);
        }
        if (orig.getWidth() == size) {
            return orig;
        }
        BufferedImage scaled = new BufferedImage(size, size, 2);
        Graphics2D g2 = scaled.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, INTERPOLATION);
        g2.drawImage(orig, 0, 0, size, size, 0, 0, orig.getWidth(), orig.getHeight(), null);
        return scaled;
    }

    private int getNextLargerSize(int size) {
        int nextSize = -1;
        int delta = Integer.MAX_VALUE;
        for (int x : this.map.keySet()) {
            int diff;
            if (x < size || (diff = x - size) >= delta) continue;
            nextSize = x;
            delta = diff;
        }
        return nextSize;
    }

    private int getLargestSize() {
        int max = Integer.MIN_VALUE;
        for (int x : this.map.keySet()) {
            if (x <= max) continue;
            max = x;
        }
        return max;
    }
}

