/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.app.view.graphics;

import hsr.pma.app.view.feedback.FeedbackFactory;
import hsr.pma.app.view.feedback.IFeedback;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class GraphicsContext {
    private static final double GRID = 0.1;
    private static final double BORDER_WIDTH = 0.112094;
    private static final double BORDER_HEIGHT = 0.114286;
    private static final double SCALE_NEXT_BUTTON = 1.0;
    private static final double SCALE_FEEDBACK_ICON = 0.8;
    private static final double SCALE_FONT_SIZE_100 = 0.375;
    private static final double SCALE_TITLE_TEXT_Y_GAP = 0.25;
    private static final double SCALE_ANSWER_BUTTON_X_GAP = 0.6;
    private static final double SCALE_ANSWER_BUTTON_LABEL_Y_GAP = 0.1;
    public static final String FONT_FAMILY = "Tahoma";
    protected final JPanel panel;
    protected IFeedback feedback;

    public GraphicsContext(JPanel panel) {
        this.panel = panel;
        this.feedback = this.createFeedback();
    }

    protected IFeedback createFeedback() {
        return FeedbackFactory.getFeedback();
    }

    public Dimension getSize() {
        return this.panel.getSize();
    }

    public Insets getBorder() {
        Dimension d = this.panel.getSize();
        int top = (int)((double)d.height * 0.114286);
        int left = (int)((double)d.width * 0.112094);
        return new Insets(top, left, top, left);
    }

    public double getGrid() {
        Dimension d = this.getSize();
        return Math.sqrt(d.width * d.height) * 0.1;
    }

    public int getButtonSize() {
        return (int)(this.getGrid() * 1.0);
    }

    public int getFeedbackImageSize() {
        return (int)(this.getGrid() * 0.8);
    }

    protected int getFontSize100() {
        return (int)(this.getGrid() * 0.375);
    }

    public Font getFont(int fontSize) {
        int size = (int)((double)fontSize / 100.0 * (double)this.getFontSize100());
        return new Font(FONT_FAMILY, 0, size);
    }

    public Font getFontBold(int fontSize) {
        int size = (int)((double)fontSize / 100.0 * (double)this.getFontSize100());
        return new Font(FONT_FAMILY, 1, size);
    }

    public BufferedImage getFeedbackOkImage() {
        return this.feedback.getOkImage(this.getFeedbackImageSize());
    }

    public BufferedImage getFeedbackFailImage() {
        return this.feedback.getFailImage(this.getFeedbackImageSize());
    }

    public int getAnswerButtonXGap() {
        return (int)(this.getGrid() * 0.6);
    }

    public int getAnswerButtonLabelYGap() {
        return (int)(this.getGrid() * 0.1);
    }

    public int getTitleTextYGap() {
        return (int)(this.getGrid() * 0.25);
    }
}

