/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.memorization.data;

import hsr.pma.app.ResultStep;
import hsr.pma.memorization.data.ResultAnswer;
import hsr.pma.util.Time;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class MemorizationApplicationResultStep
extends ResultStep {
    private static final long serialVersionUID = -3361033925335795643L;
    public static final String CLASS_NAME = "hsr.pma.memorization.data.MemorizationApplicationResultStep";
    private static final String RUNTIMEEXCEPTION_RESULT = "Fehler beim Einlesen der Resultate";
    private static final String XMLATTRIBUTE_DIFFICULTY = "difficulty";
    private static final String XMLELEMENT_DIFFICULTY = "Difficulty";
    private static final String XMLELEMENT_ANSWER = "Answer";
    private static final String XMLELEMENT_MEMORYSEQUENCE = "MemorySequence";
    private static final String XMLATTRIBUTE_STARTTIME = "time";
    public final int difficulty;
    public final String memorySequence;
    private ArrayList<ResultAnswer> resultAnswer;

    public MemorizationApplicationResultStep(int difficulty, String memorySequence, Time started) {
        this.difficulty = difficulty;
        this.memorySequence = memorySequence;
        this.started = started;
        this.resultAnswer = new ArrayList();
    }

    private void addListAnswers(List<Element> answers) throws RuntimeException {
        for (Element answer : answers) {
            ResultAnswer newAnswer = ResultAnswer.fromXML(answer);
            this.resultAnswer.add(newAnswer);
        }
    }

    public void addResultAnswer(boolean isCorrect, Time startTime, long reactionTime, char correctAnswer, char givenAnswer) {
        ResultAnswer newAnswer = new ResultAnswer(isCorrect, startTime, reactionTime, correctAnswer, givenAnswer);
        this.resultAnswer.add(newAnswer);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public Element toXML() {
        Element el = new Element("ResultStep");
        el.setAttribute(XMLATTRIBUTE_STARTTIME, this.started.toString());
        Element edifficulty = new Element(XMLELEMENT_DIFFICULTY);
        edifficulty.setText(Integer.toString(this.difficulty));
        el.addContent(edifficulty);
        Element memorySequenceElement = new Element(XMLELEMENT_MEMORYSEQUENCE);
        memorySequenceElement.setText(this.memorySequence);
        memorySequenceElement.setAttribute("length", "" + this.memorySequence.length());
        el.addContent(memorySequenceElement);
        for (ResultAnswer resultAnswerElement : this.resultAnswer) {
            el.addContent(resultAnswerElement.toXML());
        }
        return el;
    }

    public static MemorizationApplicationResultStep fromXML(Element element) {
        try {
            Time started = new Time();
            String time = element.getAttributeValue(XMLATTRIBUTE_STARTTIME);
            if (time != null && time.length() > 0) {
                started = new Time(time);
            }
            int difficulty = 0;
            String x = element.getAttributeValue(XMLATTRIBUTE_DIFFICULTY);
            if (x != null && x.length() > 0) {
                difficulty = Integer.parseInt(x);
            }
            if ((x = element.getChildText(XMLELEMENT_DIFFICULTY)) != null && x.length() > 0) {
                difficulty = Integer.parseInt(x);
            }
            String memorySequence = element.getChildText(XMLELEMENT_MEMORYSEQUENCE);
            MemorizationApplicationResultStep step = new MemorizationApplicationResultStep(difficulty, memorySequence, started);
            step.addListAnswers(element.getChildren(XMLELEMENT_ANSWER));
            return step;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(RUNTIMEEXCEPTION_RESULT);
        }
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public String getMemorySequence() {
        return this.memorySequence;
    }

    public ArrayList<ResultAnswer> getResultAnswer() {
        return this.resultAnswer;
    }
}

