/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.memorization.data;

import hsr.pma.memorization.controller.Controller;
import hsr.pma.memorization.data.MemorizationApplicationResultStep;
import hsr.pma.util.Clock;
import hsr.pma.util.Time;
import java.util.ArrayList;
import java.util.List;

public class ResultStepHandler {
    private List<MemorizationApplicationResultStep> steps = new ArrayList<MemorizationApplicationResultStep>();
    private MemorizationApplicationResultStep activeStep;
    private Controller controller;

    public ResultStepHandler(Controller controller) {
        this.controller = controller;
    }

    public void abort() {
        if (this.activeStep == null) {
            return;
        }
        if (this.activeStep.getResultAnswer().size() == 0) {
            return;
        }
        this.fireResultStep();
    }

    public void createNewResultStep(int difficulty, String sequence) {
        MemorizationApplicationResultStep resultStep;
        Time started = Clock.getInstance().getTime();
        this.activeStep = resultStep = new MemorizationApplicationResultStep(difficulty, sequence, started);
    }

    public void addAnswer(boolean isCorrect, Time startTime, long reactionTime, String correctAnswer, String givenAnswer) {
        this.activeStep.addResultAnswer(isCorrect, startTime, reactionTime, correctAnswer.charAt(0), givenAnswer.charAt(0));
    }

    public void fireResultStep() {
        this.steps.add(this.activeStep);
        this.controller.saveResultStep(this.activeStep);
        this.activeStep = null;
    }
}

