/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.memorization.model;

import hsr.pma.Language;
import hsr.pma.memorization.controller.Controller;
import hsr.pma.memorization.model.QuestionSlideListener;
import hsr.pma.memorization.model.Slide;
import hsr.pma.memorization.model.xml.SimpleText;
import hsr.pma.memorization.model.xml.Text;
import hsr.pma.util.Clock;
import hsr.pma.util.Time;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Timer;

public class QuestionSlide
extends Slide {
    protected Controller controller;
    private Text title;
    private Text text;
    private List<SimpleText> buttons;
    private List<SimpleText> joystickLabels;
    protected String sequence;
    protected boolean lastQuestion = false;
    protected boolean displayNextButton = false;
    private Time startTime = null;
    protected Timer timer;
    protected double timeout;
    protected QuestionSlideListener listener;

    public QuestionSlide(Controller controller, Text title, Text text, List<SimpleText> answers, List<SimpleText> joystickLabels, String sequence, boolean lastQuestion, boolean displayNextButton, double timeout) {
        this.controller = controller;
        this.title = title;
        this.text = text;
        this.buttons = answers;
        this.joystickLabels = joystickLabels;
        this.sequence = sequence;
        this.lastQuestion = lastQuestion;
        this.displayNextButton = displayNextButton;
        this.timeout = timeout;
    }

    @Override
    public void setLanguage(Language lang) {
        this.title.setLanguage(lang);
        this.text.setLanguage(lang);
    }

    @Override
    public void start() {
        this.startTime = Clock.getInstance().getTime();
    }

    @Override
    public void stop() {
        this.controller.getResultStepHandler().abort();
    }

    public void handleAnswerButtonPressed(String givenAnswer) {
        Time now = Clock.getInstance().getTime();
        long reactionTime = now.getMillis() - this.startTime.getMillis();
        this.controller.getResultStepHandler().addAnswer(this.isCorrect(givenAnswer), this.startTime, reactionTime, this.getCorrectAnswer(), givenAnswer);
        if (this.lastQuestion) {
            this.controller.getResultStepHandler().fireResultStep();
        }
        this.timer = new Timer((int)(this.timeout * 1000.0), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                QuestionSlide.this.handleTimeoutTimer();
            }
        });
        this.timer.setRepeats(false);
        this.timer.start();
    }

    protected void handleTimeoutTimer() {
        if (this.lastQuestion && this.displayNextButton) {
            this.fireShowNextButton();
            return;
        }
        this.controller.nextSlide();
    }

    public void handleNextButtonPressed() {
        this.controller.nextSlide();
    }

    public Text getTitle() {
        return this.title;
    }

    public Text getText() {
        return this.text;
    }

    public List<SimpleText> getButtons() {
        return this.buttons;
    }

    public List<SimpleText> getJoystickLabels() {
        return this.joystickLabels;
    }

    protected boolean isCorrect(String givenAnswer) {
        return this.sequence.contains(givenAnswer);
    }

    protected String getCorrectAnswer() {
        for (SimpleText but : this.buttons) {
            if (!this.sequence.contains(but.getText())) continue;
            return but.getText();
        }
        System.err.println("there is no correct answer");
        return "";
    }

    protected void fireShowNextButton() {
        if (this.listener != null) {
            this.listener.showNextButton();
        }
    }

    public void setQuestionSlideListener(QuestionSlideListener listener) {
        this.listener = listener;
    }
}

