/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.memorization.model;

import hsr.pma.Language;
import hsr.pma.app.ITestApplication;
import hsr.pma.memorization.controller.Controller;
import hsr.pma.memorization.model.Slide;
import hsr.pma.memorization.model.TimerText;
import hsr.pma.memorization.model.xml.SimpleText;
import hsr.pma.memorization.model.xml.Text;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class SequenceSlide
extends Slide {
    private Controller controller;
    private Text title;
    private Text text;
    private SimpleText sequence;
    private double timeout;
    private int difficulty;
    private boolean displayTimer;
    private TimerText timerText;
    private Timer timer;

    public SequenceSlide(Controller controller, Text title, Text text, SimpleText sequence, double timeout, int difficulty, boolean displayTimer) {
        this.controller = controller;
        this.title = title;
        this.text = text;
        this.sequence = sequence;
        this.timeout = timeout;
        this.difficulty = difficulty;
        this.displayTimer = displayTimer;
        this.timerText = new TimerText(timeout);
    }

    @Override
    public void setLanguage(Language lang) {
        this.title.setLanguage(lang);
        this.text.setLanguage(lang);
        this.timerText.setLanguage(lang);
    }

    public Text getTitle() {
        return this.title;
    }

    public Text getText() {
        return this.text;
    }

    public SimpleText getSequence() {
        return this.sequence;
    }

    public TimerText getTimerText() {
        return this.timerText;
    }

    public boolean displayTimer() {
        return this.displayTimer;
    }

    @Override
    public void start() {
        if (this.controller.getState().equals((Object)ITestApplication.State.TESTING)) {
            this.controller.getResultStepHandler().createNewResultStep(this.difficulty, this.sequence.getText());
        }
        this.timer = new Timer((int)(this.timeout * 1000.0), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SequenceSlide.this.controller.nextSlide();
            }
        });
        this.timer.setRepeats(false);
        if (this.displayTimer) {
            this.timerText.start();
        }
        this.timer.start();
    }

    @Override
    public void stop() {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timerText.stop();
    }
}

