/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.memorization.model;

import hsr.pma.memorization.controller.Controller;
import hsr.pma.memorization.model.ExampleQuestionSlide;
import hsr.pma.memorization.model.InfoSlide;
import hsr.pma.memorization.model.InterferenceSlide;
import hsr.pma.memorization.model.QuestionSlide;
import hsr.pma.memorization.model.SequenceSlide;
import hsr.pma.memorization.model.Slide;
import hsr.pma.memorization.model.StepRandomizer;
import hsr.pma.memorization.model.xml.Init;
import hsr.pma.memorization.model.xml.InstructionStep;
import hsr.pma.memorization.model.xml.SimpleText;
import hsr.pma.memorization.model.xml.Step;
import hsr.pma.memorization.model.xml.TestSequence;
import hsr.pma.memorization.model.xml.TestStep;
import hsr.pma.memorization.model.xml.Text;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SlideFactory {
    private Controller controller;
    private Init init;

    public SlideFactory(Controller controller) {
        this.controller = controller;
        this.init = controller.getConfiguration().getInit();
    }

    public List<Slide> createInstructionSlides(List<Step> steps) {
        ArrayList<Slide> result = new ArrayList<Slide>();
        for (Step step : steps) {
            if (step instanceof InstructionStep) {
                result.add(this.createInfoSlide((InstructionStep)step));
                continue;
            }
            if (!(step instanceof TestSequence)) continue;
            TestSequence ts = (TestSequence)step;
            result.add(this.createSequenceSlideInstruction(ts));
            result.add(this.createInterferenceSlide());
            result.addAll(this.createExampleQuestionSlides(ts));
        }
        for (Slide slide : result) {
            slide.setLanguage(this.controller.getLanguage());
        }
        return result;
    }

    public List<Slide> createTestSlides(List<Step> steps) {
        if (this.init.isRandomOperation()) {
            steps = new StepRandomizer().randomizeSteps(steps);
        } else if (this.init.isRandomizedPool()) {
            steps = new StepRandomizer().randomizeStepsPooled(steps, this.init.getRandomizedPoolExerciseCount());
        }
        ArrayList<Slide> result = new ArrayList<Slide>();
        for (Step step : steps) {
            if (step instanceof InstructionStep) {
                result.add(this.createInfoSlide((InstructionStep)step));
                continue;
            }
            if (!(step instanceof TestSequence)) continue;
            TestSequence ts = (TestSequence)step;
            result.add(this.createSequenceSlideTest(ts));
            result.add(this.createInterferenceSlide());
            result.addAll(this.createQuestionSlides(ts));
        }
        for (Slide slide : result) {
            slide.setLanguage(this.controller.getLanguage());
        }
        return result;
    }

    private InfoSlide createInfoSlide(InstructionStep step) {
        return new InfoSlide(this.controller, step.getTitle(), step.getText());
    }

    private InterferenceSlide createInterferenceSlide() {
        return new InterferenceSlide(this.controller, this.init.getInterferenceTime());
    }

    private SequenceSlide createSequenceSlideInstruction(TestSequence testSequence) {
        Text title = this.init.getInstructionCommandTitle();
        Text text = this.init.getCommandText();
        SimpleText sequence = testSequence.getSequence();
        double duration = testSequence.getDuration();
        int difficulty = testSequence.getDifficulty();
        boolean displayTimer = this.init.isDisplayTimer();
        return new SequenceSlide(this.controller, title, text, sequence, duration, difficulty, displayTimer);
    }

    private SequenceSlide createSequenceSlideTest(TestSequence testSequence) {
        Text title = this.init.getCommandTitle();
        Text text = this.init.getCommandText();
        SimpleText sequence = testSequence.getSequence();
        double duration = testSequence.getDuration();
        int difficulty = testSequence.getDifficulty();
        boolean displayTimer = this.init.isDisplayTimer();
        return new SequenceSlide(this.controller, title, text, sequence, duration, difficulty, displayTimer);
    }

    private List<Slide> createQuestionSlides(TestSequence testSequence) {
        ArrayList<Slide> slides = new ArrayList<Slide>();
        Iterator<TestStep> iter = testSequence.getSteps().iterator();
        while (iter.hasNext()) {
            TestStep teststep = iter.next();
            boolean lastQuestion = !iter.hasNext();
            boolean displayNextButton = this.init.isDisplayNextButton();
            double timeout = this.init.getTestDelay();
            QuestionSlide qs = new QuestionSlide(this.controller, this.init.getQuestionTitle(), this.init.getQuestionText(), teststep.getAnswers(), this.init.getJoystickLabels(), testSequence.getSequence().getText(), lastQuestion, displayNextButton, timeout);
            slides.add(qs);
        }
        return slides;
    }

    private List<Slide> createExampleQuestionSlides(TestSequence testSequence) {
        ArrayList<Slide> slides = new ArrayList<Slide>();
        Iterator<TestStep> iter = testSequence.getSteps().iterator();
        while (iter.hasNext()) {
            TestStep teststep = iter.next();
            boolean lastQuestion = !iter.hasNext();
            boolean displayNextButton = this.init.isDisplayNextButton();
            double timeout = this.init.getFeedbackTime();
            ExampleQuestionSlide qs = new ExampleQuestionSlide(this.controller, this.init.getQuestionTitle(), this.init.getQuestionText(), teststep.getAnswers(), this.init.getJoystickLabels(), testSequence.getSequence().getText(), lastQuestion, displayNextButton, timeout);
            slides.add(qs);
        }
        return slides;
    }
}

