/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.memorization.model;

import hsr.pma.memorization.model.xml.Step;
import hsr.pma.memorization.model.xml.TestSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;

public class StepRandomizer {
    Random r = new Random(System.currentTimeMillis());
    private Hashtable<Integer, List<TestSequence>> sorted = new Hashtable();

    public List<Step> randomizeSteps(List<Step> steps) {
        for (Step step : steps) {
            if (!(step instanceof TestSequence)) continue;
            TestSequence ts = (TestSequence)step;
            List<TestSequence> list = this.sorted.get(ts.getDifficulty());
            if (list == null) {
                list = new ArrayList<TestSequence>();
                this.sorted.put(ts.getDifficulty(), list);
            }
            list.add(ts);
        }
        for (Integer key : this.sorted.keySet()) {
            List<TestSequence> list = this.sorted.get(key);
            Collections.shuffle(list, this.r);
        }
        ArrayList<Step> result = new ArrayList<Step>();
        for (Step step : steps) {
            if (!(step instanceof TestSequence)) {
                result.add(step);
                continue;
            }
            TestSequence ts = (TestSequence)step;
            List<TestSequence> shuffled = this.sorted.get(ts.getDifficulty());
            TestSequence exchange = shuffled.remove(0);
            result.add(exchange);
        }
        return result;
    }

    public List<Step> randomizeStepsPooled(List<Step> steps, int exerciseCount) {
        ArrayList<TestSequence> shuffled = new ArrayList<TestSequence>();
        for (Step step : steps) {
            if (!(step instanceof TestSequence)) continue;
            shuffled.add((TestSequence)step);
        }
        Collections.shuffle(shuffled, this.r);
        int count = 0;
        ArrayList<Step> result = new ArrayList<Step>();
        for (Step step : steps) {
            if (!(step instanceof TestSequence)) {
                result.add(step);
            }
            if (!(step instanceof TestSequence) || count >= exerciseCount) continue;
            result.add((Step)shuffled.remove(shuffled.size() - 1));
            ++count;
        }
        return result;
    }
}

