/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.memorization.model;

import hsr.pma.Language;
import hsr.pma.memorization.model.TimerTickListener;
import hsr.pma.memorization.model.xml.Text;
import hsr.pma.memorization.view.MemorizationLayouter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class TimerText
extends Text {
    private static final long serialVersionUID = 1L;
    private static final int LOOP = 50;
    private long started;
    private double timeout;
    private Timer timer;
    private int restSeconds;
    private TimerTickListener listener;

    public TimerText(double timeout) {
        this.texts.put(Language.GERMAN, "Sekunden");
        this.texts.put(Language.FRENCH, "Secondes");
        this.texts.put(Language.ITALIAN, "Secondi");
        this.texts.put(Language.ENGLISH, "Seconds");
        this.timeout = timeout;
        this.restSeconds = (int)Math.round(timeout);
        this.fontSize = MemorizationLayouter.getFontSize("TimerText");
    }

    public void start() {
        this.started = System.currentTimeMillis();
        this.timer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TimerText.this.handleTick();
            }
        });
        this.timer.setRepeats(true);
        this.timer.start();
    }

    public void stop() {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    private void handleTick() {
        long deltaMs = System.currentTimeMillis() - this.started;
        double resttime = this.timeout - (double)deltaMs / 1000.0;
        int newRestSeconds = (int)Math.round(resttime);
        if (newRestSeconds == this.restSeconds) {
            return;
        }
        this.restSeconds = newRestSeconds;
        if (this.restSeconds < 1) {
            this.stop();
            return;
        }
        if (this.listener != null) {
            this.listener.refreshTimerText(this.getTimerText());
        }
    }

    public String getTimerText() {
        return this.restSeconds + " " + this.getText();
    }

    public void setListener(TimerTickListener listener) {
        this.listener = listener;
    }
}

