/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.memorization.model.xml;

import hsr.pma.memorization.model.xml.SimpleText;
import hsr.pma.memorization.model.xml.Step;
import hsr.pma.memorization.model.xml.TestStep;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class TestSequence
implements Step {
    private static final long serialVersionUID = 1L;
    private int difficulty = 1;
    private SimpleText sequence;
    private double duration = 6.0;
    private List<TestStep> steps = new ArrayList<TestStep>();

    public TestSequence(Element el) {
        this.difficulty = Integer.parseInt(el.getAttributeValue("difficulty"));
        this.sequence = new SimpleText(el.getChild("MemorySequence"));
        this.duration = Double.parseDouble(el.getChildText("DisplayDuration"));
        for (Object obj : el.getChildren("TestStep")) {
            this.steps.add(new TestStep((Element)obj));
        }
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public SimpleText getSequence() {
        return this.sequence;
    }

    public double getDuration() {
        return this.duration;
    }

    public List<TestStep> getSteps() {
        return this.steps;
    }

    @Override
    public Element toXml() {
        Element el = new Element("TestSequence");
        el.setAttribute("difficulty", "" + this.difficulty);
        el.addContent(this.sequence.toXml("MemorySequence"));
        Element ed = new Element("DisplayDuration");
        ed.setText("" + this.duration);
        el.addContent(ed);
        for (TestStep ts : this.steps) {
            el.addContent(ts.toXml());
        }
        return el;
    }
}

