/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.memorization.view;

import hsr.pma.app.view.graphics.ApplicationLayouter;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MemorizationLayouter
extends ApplicationLayouter {
    private static final int FONT_SIZE_TEXT = 100;
    private static final int FONT_SIZE_TITLE = 130;
    private static final int FONT_SIZE_SEQUENCE = 260;
    private static final int FONT_SIZE_JOYSTICK_LABEL = 100;
    private static final int FONT_SIZE_BUTTON = 130;
    private static final int FONT_SIZE_TIMER_TEXT = 80;

    public static int getFontSize(String elementName) {
        if (elementName.equals("TimerText")) {
            return 80;
        }
        if (elementName.contains("Text")) {
            return 100;
        }
        if (elementName.contains("Title")) {
            return 130;
        }
        if (elementName.equals("MemorySequence")) {
            return 260;
        }
        if (elementName.startsWith("Button")) {
            return 100;
        }
        if (elementName.equals("Answer")) {
            return 130;
        }
        return 100;
    }

    public MemorizationLayouter(JPanel panel) {
        super(panel);
    }

    public void layoutTitleText(JComponent title, JComponent text, int fontSizeTitle, int fontSizeText) {
        int titleHeight = this.layoutTitle(title, fontSizeTitle);
        int ygap = this.gc.getTitleTextYGap();
        int yOffset = this.gc.getBorder().top + titleHeight + ygap;
        this.layoutText(text, yOffset, fontSizeText);
    }

    public void layoutTextCenteredBold(JComponent text, int fontSize) {
        text.setFont(this.gc.getFontBold(fontSize));
        Dimension labelSize = text.getPreferredSize();
        int xOffset = (this.gc.getSize().width - labelSize.width) / 2;
        int yOffset = (this.gc.getSize().height - labelSize.height) / 2;
        text.setBounds(xOffset, yOffset, labelSize.width, labelSize.height);
    }

    public void layoutTextSouthCentered(JComponent text, int fontSize) {
        text.setFont(this.gc.getFont(fontSize));
        Dimension labelSize = text.getPreferredSize();
        int xOffset = (this.gc.getSize().width - labelSize.width) / 2;
        int yOffset = this.gc.getSize().height - this.gc.getBorder().bottom - labelSize.height;
        text.setBounds(xOffset, yOffset, labelSize.width, labelSize.height);
    }

    public void layoutButtons(List<JButton> buttons, List<Integer> fontSize) {
        int i = 0;
        while (i < buttons.size()) {
            buttons.get(i).setFont(this.gc.getFontBold(fontSize.get(i)));
            ++i;
        }
        int butSize = this.gc.getButtonSize();
        int butGap = this.gc.getAnswerButtonXGap();
        int xOffset = (this.gc.getSize().width - butSize * buttons.size() - (butGap * buttons.size() - 1)) / 2;
        int yOffset = this.gc.getSize().height / 2;
        for (JButton but : buttons) {
            but.setBounds(xOffset, yOffset, butSize, butSize);
            xOffset += butSize + butGap;
        }
    }

    public void layoutButtonLabels(List<JLabel> labels, List<Integer> fontSize) {
        int i = 0;
        while (i < labels.size()) {
            labels.get(i).setFont(this.gc.getFont(fontSize.get(i)));
            labels.get(i).setForeground(COLOR_TITLE);
            ++i;
        }
        int butSize = this.gc.getButtonSize();
        int butGap = this.gc.getAnswerButtonXGap();
        int xOffset = (this.gc.getSize().width - butSize * labels.size() - (butGap * labels.size() - 1)) / 2;
        int yOffset = this.gc.getSize().height / 2 + butSize + this.gc.getAnswerButtonLabelYGap();
        for (JLabel lab : labels) {
            Dimension labelSize = lab.getPreferredSize();
            int xAddOffset = (butSize - labelSize.width) / 2;
            lab.setBounds(xOffset + xAddOffset, yOffset, labelSize.width, labelSize.height);
            xOffset += butSize + butGap;
        }
    }
}

