/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.standalone.model;

import java.awt.Dimension;
import org.jdom.Element;

public class Window {
    private boolean resizable = true;
    private int width = 200;
    private int height = 200;

    public Window() {
    }

    public Window(Element el) {
        this.width = Integer.parseInt(el.getAttributeValue("width"));
        this.height = Integer.parseInt(el.getAttributeValue("height"));
        this.resizable = Boolean.parseBoolean(el.getAttributeValue("resizable"));
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (width < 100) {
            throw new IllegalArgumentException("[Window] width is to small");
        }
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        if (height < 100) {
            throw new IllegalArgumentException("[Window] height is to small");
        }
        this.height = height;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public Element toXml() {
        Element el = new Element("Window");
        el.setAttribute("width", "" + this.width);
        el.setAttribute("height", "" + this.height);
        el.setAttribute("resizable", "" + this.resizable);
        return el;
    }
}

