/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.standalone.view;

import hsr.pma.standalone.Locator;
import hsr.pma.standalone.model.ApplicationScreen;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class ApplicationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static boolean DEBUG = false;
    private final ApplicationScreen screen;
    private JPanel contentPanel;

    public ApplicationPanel(ApplicationScreen screen) {
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.screen = screen;
        this.setLayout(null);
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.add(this.contentPanel);
        if (DEBUG) {
            this.contentPanel.setBorder(new LineBorder(Color.RED));
        }
        ImagePanel imagePanel = new ImagePanel();
        JFrame frame = Locator.getFrame();
        JPanel glass = (JPanel)frame.getGlassPane();
        glass.setLayout(new BorderLayout());
        glass.add((Component)imagePanel, "Center");
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width > 100) {
            this.mylayout();
        }
    }

    private void mylayout() {
        Dimension d = this.getSize();
        Insets p = this.screen.getPadding().getInsets();
        int width = d.width - p.left - p.right;
        int height = d.height - p.top - p.bottom;
        this.contentPanel.setBounds(p.left, p.top, width, height);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(g);
        if (DEBUG) {
            this.paintDebugBorder(g);
        }
    }

    private void paintDebugBorder(Graphics g) {
        if (!DEBUG) {
            return;
        }
        Dimension d = this.getSize();
        Insets p = this.screen.getPadding().getInsets();
        int width = d.width - p.left - p.right;
        int height = d.height - p.top - p.bottom;
        g.setColor(Color.ORANGE);
        g.drawRect(p.left, p.top, width, height);
    }

    class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public ImagePanel() {
            this.setOpaque(false);
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paintComponent(g);
            String himgname = ApplicationPanel.this.screen.getHeader().getImage();
            Image himage = Locator.getImageProvider().getScaledImage(himgname);
            g.drawImage(himage, 0, 0, himage.getWidth(null), himage.getHeight(null), null);
            String fimgname = ApplicationPanel.this.screen.getFooter().getImage();
            Image fimage = Locator.getImageProvider().getScaledImage(fimgname);
            int yoffset = this.getSize().height - fimage.getHeight(null);
            g.drawImage(fimage, 0, yoffset, fimage.getWidth(null), fimage.getHeight(null), null);
        }
    }
}

