/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.standalone.view;

import hsr.pma.app.view.components.ALabel;
import hsr.pma.app.view.components.NextButton;
import hsr.pma.standalone.Locator;
import hsr.pma.standalone.model.ResultScreen;
import hsr.pma.standalone.view.GraphicsContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class ResultPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static boolean DEBUG = false;
    private final ResultScreen screen;
    private JLabel title;
    private JLabel text;
    private JLabel resultLabel;
    private JButton nextButton;
    private int result = 0;
    private int value = 0;
    private Timer timer;

    public ResultPanel(ResultScreen screen) {
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.screen = screen;
        this.setLayout(null);
        this.title = new ALabel(screen.getTitle().getText());
        this.add(this.title);
        this.text = new ALabel(screen.getResult());
        this.add(this.text);
        this.resultLabel = new ALabel("0%");
        this.add(this.resultLabel);
        this.nextButton = new NextButton();
        this.add(this.nextButton);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Locator.getController().showControl();
            }
        });
        this.nextButton.setEnabled(false);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width > 100) {
            this.mylayout();
        }
    }

    private void mylayout() {
        GraphicsContext gc = Locator.getGraphicsContext();
        this.title.setFont(gc.getFontBold(this.screen.getTitle().getFontSize()));
        this.text.setFont(gc.getFont(this.screen.getText().getFontSize()));
        this.resultLabel.setFont(gc.getFontBold(100));
        Dimension d = this.getSize();
        Insets p = this.screen.getPadding().getInsets();
        int height = d.height - p.top - p.bottom;
        int unit = gc.getUnit();
        int twidth = this.title.getPreferredSize().width;
        int theight = this.title.getPreferredSize().height;
        this.title.setBounds(p.left, p.top, twidth, theight);
        twidth = this.text.getPreferredSize().width;
        theight = this.text.getPreferredSize().height;
        this.text.setBounds(p.left, p.top + height / 2 + unit, twidth, theight);
        int nextHeight = gc.getNextButtonHeight();
        this.nextButton.setBounds(d.width - p.right - nextHeight, d.height - p.bottom - nextHeight, nextHeight, nextHeight);
    }

    public void runAnimation() {
        this.text.setVisible(false);
        this.nextButton.setEnabled(false);
        this.result = this.screen.getResultPercent();
        this.value = 0;
        this.timer = new Timer(30, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ResultPanel.this.myaction();
            }
        });
        this.timer.start();
    }

    private void myaction() {
        if (this.value >= this.result) {
            this.timer.stop();
            this.text.setVisible(true);
            this.nextButton.setEnabled(true);
            return;
        }
        ++this.value;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintDebugBorder(g);
        Dimension d = this.getSize();
        Insets p = this.screen.getPadding().getInsets();
        int width = d.width - p.left - p.right;
        int height = d.height - p.top - p.bottom;
        GraphicsContext gc = Locator.getGraphicsContext();
        int unit = gc.getUnit();
        int rheight = 2 * unit;
        g2.setStroke(new BasicStroke((float)((double)unit / 20.0), 1, 1));
        int width2 = (int)((double)(width * this.value) / 100.0);
        int yOffset = p.top + height / 2 - 3 * unit;
        g2.setColor(this.getColor(this.value));
        g2.fillRect(p.left, yOffset, width2, rheight);
        g2.setColor(Color.DARK_GRAY);
        g2.drawRect(p.left, yOffset, width, rheight);
        this.resultLabel.setText(this.value + "%");
        int twidth = this.resultLabel.getPreferredSize().width;
        int theight = this.resultLabel.getPreferredSize().height;
        int xOffset = p.left + (width - twidth) / 2;
        this.resultLabel.setBounds(xOffset, yOffset + (rheight - theight) / 2, twidth, theight);
        String himgname = this.screen.getHeader().getImage();
        Image himage = Locator.getImageProvider().getScaledImage(himgname);
        g.drawImage(himage, 0, 0, himage.getWidth(null), himage.getHeight(null), null);
        String fimgname = this.screen.getFooter().getImage();
        Image fimage = Locator.getImageProvider().getScaledImage(fimgname);
        int yoffset = this.getSize().height - fimage.getHeight(null);
        g.drawImage(fimage, 0, yoffset, fimage.getWidth(null), fimage.getHeight(null), null);
    }

    private Color getColor(int percent) {
        double x = (double)percent / 100.0;
        double h0 = 14.0;
        double h1 = 90.0;
        double hx = h0 + (h1 - h0) * x;
        float fx = (float)(hx / 360.0);
        int rgb = Color.HSBtoRGB(fx, 0.9f, 1.0f);
        return new Color(rgb);
    }

    private void paintDebugBorder(Graphics g) {
        if (!DEBUG) {
            return;
        }
        Dimension d = this.getSize();
        Insets p = this.screen.getPadding().getInsets();
        int width = d.width - p.left - p.right;
        int height = d.height - p.top - p.bottom;
        g.setColor(Color.RED);
        g.drawRect(p.left, p.top, width, height);
    }
}

